/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.automaton.api.process.IBuilderProcess;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import java.util.Objects;
import net.minecraft.core.BlockPos;

public class DestroyBlockTask
extends Task
implements ITaskRequiresGrounded {
    private final BlockPos pos;
    private boolean isClear;

    public DestroyBlockTask(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    protected void onStart() {
        this.isClear = false;
        IBuilderProcess builder = this.controller.getBaritone().getBuilderProcess();
        builder.clearArea(this.pos, this.pos);
    }

    @Override
    protected Task onTick() {
        IBuilderProcess builder = this.controller.getBaritone().getBuilderProcess();
        if (!builder.isActive()) {
            this.isClear = true;
            return null;
        }
        this.setDebugState("Automatone is breaking the block.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        IBuilderProcess builder = this.controller.getBaritone().getBuilderProcess();
        if (builder.isActive()) {
            builder.onLostControl();
        }
    }

    @Override
    public boolean isFinished() {
        return this.isClear || this.controller.getWorld().m_46859_(this.pos);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof DestroyBlockTask) {
            DestroyBlockTask task = (DestroyBlockTask)other;
            bl = Objects.equals(task.pos, this.pos);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Destroying block at " + this.pos.m_123344_();
    }
}

