/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class ProjectileProtectionWallTask
extends Task
implements ITaskRequiresGrounded {
    private final PlayerEngineController mod;
    private final TimerGame waitForBlockPlacement = new TimerGame(2.0);
    private BlockPos targetPlacePos;

    public ProjectileProtectionWallTask(PlayerEngineController mod) {
        this.mod = mod;
    }

    @Override
    protected void onStart() {
        this.waitForBlockPlacement.forceElapse();
    }

    @Override
    protected Task onTick() {
        if (this.targetPlacePos != null && !WorldHelper.isSolidBlock(this.controller, this.targetPlacePos)) {
            Optional<Slot> slot = StorageHelper.getSlotWithThrowawayBlock(this.mod, true);
            if (slot.isPresent()) {
                this.place(this.targetPlacePos, InteractionHand.MAIN_HAND, slot.get().getInventorySlot());
                this.targetPlacePos = null;
                this.setDebugState(null);
            }
            return null;
        }
        Optional<Entity> sentity = this.mod.getEntityTracker().getClosestEntity(e -> e instanceof Skeleton && EntityHelper.isAngryAtPlayer(this.mod, e) && ((Skeleton)e).m_21252_() > 8, Skeleton.class);
        if (sentity.isPresent()) {
            Vec3 playerPos = this.mod.getPlayer().m_20182_();
            Vec3 targetPos = sentity.get().m_20182_();
            Vec3 direction = playerPos.m_82546_(targetPos).m_82541_();
            double x = playerPos.f_82479_ - 2.0 * direction.f_82479_;
            double y = playerPos.f_82480_ + direction.f_82480_;
            double z = playerPos.f_82481_ - 2.0 * direction.f_82481_;
            this.targetPlacePos = new BlockPos((int)x, (int)y + 1, (int)z);
            this.setDebugState("Placing at " + this.targetPlacePos.toString());
            this.waitForBlockPlacement.reset();
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        assert (this.controller.getWorld() != null);
        Optional<Entity> entity = this.mod.getEntityTracker().getClosestEntity(e -> e instanceof Skeleton && EntityHelper.isAngryAtPlayer(this.mod, e) && ((Skeleton)e).m_21252_() > 3, Skeleton.class);
        return this.targetPlacePos != null && WorldHelper.isSolidBlock(this.mod, this.targetPlacePos) || entity.isEmpty();
    }

    @Override
    protected boolean isEqual(Task other) {
        return true;
    }

    @Override
    protected String toDebugString() {
        return "Placing blocks to block projectiles";
    }

    public Direction getPlaceSide(BlockPos blockPos) {
        for (Direction side : Direction.values()) {
            BlockPos neighbor = blockPos.m_121945_(side);
            BlockState state = this.mod.getWorld().m_8055_(neighbor);
            if (state.m_60795_() || ProjectileProtectionWallTask.isClickable(state.m_60734_()) || !state.m_60819_().m_76178_()) continue;
            return side;
        }
        return null;
    }

    public boolean place(BlockPos blockPos, InteractionHand hand, int slot) {
        if (slot < 0 || slot > 8) {
            return false;
        }
        if (!this.canPlace(blockPos)) {
            return false;
        }
        Vec3 hitPos = Vec3.m_82512_((Vec3i)blockPos);
        Direction side = this.getPlaceSide(blockPos);
        if (side == null) {
            this.place(blockPos.m_7495_(), hand, slot);
            return false;
        }
        BlockPos neighbour = blockPos.m_121945_(side);
        hitPos = hitPos.m_82520_((double)side.m_122429_() * 0.5, (double)side.m_122430_() * 0.5, (double)side.m_122431_() * 0.5);
        BlockHitResult bhr = new BlockHitResult(hitPos, side.m_122424_(), neighbour, false);
        this.mod.getPlayer().m_146922_((float)this.getYaw(hitPos));
        this.mod.getPlayer().m_146926_((float)this.getPitch(hitPos));
        this.swap(slot);
        this.interact(bhr, hand);
        return true;
    }

    public static boolean isClickable(Block block) {
        return block instanceof CraftingTableBlock || block instanceof AnvilBlock || block instanceof ButtonBlock || block instanceof BasePressurePlateBlock || block instanceof BaseEntityBlock || block instanceof BedBlock || block instanceof FenceGateBlock || block instanceof DoorBlock || block instanceof NoteBlock || block instanceof TrapDoorBlock;
    }

    public void interact(BlockHitResult blockHitResult, InteractionHand hand) {
        boolean wasSneaking = this.mod.getPlayer().m_6144_();
        this.mod.getPlayer().m_20260_(false);
        InteractionResult result = this.mod.getBaritone().getEntityContext().playerController().processRightClickBlock(this.mod.getPlayer(), (Level)this.mod.getWorld(), hand, blockHitResult);
        if (result.m_19080_()) {
            this.mod.getPlayer().m_6674_(hand);
        }
        this.mod.getPlayer().m_20260_(wasSneaking);
    }

    public boolean canPlace(BlockPos blockPos, boolean checkEntities) {
        if (blockPos == null) {
            return false;
        }
        if (!Level.m_46741_((BlockPos)blockPos) || !this.controller.getWorld().m_46739_(blockPos)) {
            return false;
        }
        return !this.mod.getWorld().m_8055_(blockPos).m_247087_() ? false : !checkEntities || this.mod.getWorld().m_45752_(Blocks.f_50080_.m_49966_(), blockPos, CollisionContext.m_82749_());
    }

    public boolean canPlace(BlockPos blockPos) {
        return this.canPlace(blockPos, true);
    }

    public boolean swap(int slot) {
        if (slot == this.mod.getBaritone().getEntityContext().inventory().selectedSlot) {
            return true;
        }
        if (slot >= 0 && slot <= 8) {
            this.mod.getBaritone().getEntityContext().inventory().selectedSlot = slot;
            return true;
        }
        return false;
    }

    public double getYaw(Vec3 pos) {
        return this.mod.getPlayer().m_146908_() + Mth.m_14177_((float)((float)Math.toDegrees(Math.atan2(pos.m_7094_() - this.mod.getPlayer().m_20189_(), pos.m_7096_() - this.mod.getPlayer().m_20185_())) - 90.0f - this.mod.getPlayer().m_146908_()));
    }

    public double getPitch(Vec3 pos) {
        double diffX = pos.m_7096_() - this.mod.getPlayer().m_20185_();
        double diffY = pos.m_7098_() - this.mod.getPlayer().m_20186_() + (double)this.mod.getPlayer().m_20236_(this.mod.getPlayer().m_20089_());
        double diffZ = pos.m_7094_() - this.mod.getPlayer().m_20189_();
        double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return this.mod.getPlayer().m_146909_() + Mth.m_14177_((float)((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - this.mod.getPlayer().m_146909_()));
    }
}

