/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ConstructIronGolemTask
extends Task {
    private BlockPos position;
    private boolean canBeFinished = false;

    public ConstructIronGolemTask() {
    }

    public ConstructIronGolemTask(BlockPos pos) {
        this.position = pos;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        this.controller.getBehaviour().addProtectedItems(Items.f_41913_, Items.f_42047_);
        this.controller.getBaritoneSettings().blocksToAvoidBreaking.get().add(Blocks.f_50075_);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (!StorageHelper.itemTargetsMetInventory(mod, this.golemMaterials(mod))) {
            this.setDebugState("Getting materials for the iron golem");
            return new CataloguedResourceTask(this.golemMaterials(mod));
        }
        if (this.position == null) {
            for (BlockPos pos : WorldHelper.scanRegion(new BlockPos(mod.getPlayer().m_146903_(), 64, mod.getPlayer().m_146907_()), new BlockPos(mod.getPlayer().m_146903_(), 128, mod.getPlayer().m_146907_()))) {
                if (mod.getWorld().m_8055_(pos).m_60734_() != Blocks.f_50016_) continue;
                this.position = pos;
                break;
            }
            if (this.position == null) {
                this.position = mod.getPlayer().m_20183_();
            }
        }
        if (!WorldHelper.isBlock(this.controller, this.position, Blocks.f_50075_)) {
            if (!WorldHelper.isBlock(this.controller, this.position, Blocks.f_50016_)) {
                this.setDebugState("Destroying block in way of base iron block");
                return new DestroyBlockTask(this.position);
            }
            this.setDebugState("Placing the base iron block");
            return new PlaceBlockTask(this.position, Blocks.f_50075_);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.m_7494_(), Blocks.f_50075_)) {
            if (!WorldHelper.isBlock(this.controller, this.position.m_7494_(), Blocks.f_50016_)) {
                this.setDebugState("Destroying block in way of center iron block");
                return new DestroyBlockTask(this.position.m_7494_());
            }
            this.setDebugState("Placing the center iron block");
            return new PlaceBlockTask(this.position.m_7494_(), Blocks.f_50075_);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.m_7494_().m_122029_(), Blocks.f_50075_)) {
            if (!WorldHelper.isBlock(this.controller, this.position.m_7494_().m_122029_(), Blocks.f_50016_)) {
                this.setDebugState("Destroying block in way of east iron block");
                return new DestroyBlockTask(this.position.m_7494_().m_122029_());
            }
            this.setDebugState("Placing the east iron block");
            return new PlaceBlockTask(this.position.m_7494_().m_122029_(), Blocks.f_50075_);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.m_7494_().m_122024_(), Blocks.f_50075_)) {
            if (!WorldHelper.isBlock(this.controller, this.position.m_7494_().m_122024_(), Blocks.f_50016_)) {
                this.setDebugState("Destroying block in way of west iron block");
                return new DestroyBlockTask(this.position.m_7494_().m_122024_());
            }
            this.setDebugState("Placing the west iron block");
            return new PlaceBlockTask(this.position.m_7494_().m_122024_(), Blocks.f_50075_);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.m_122029_(), Blocks.f_50016_)) {
            this.setDebugState("Clearing area on east side...");
            return new DestroyBlockTask(this.position.m_122029_());
        }
        if (!WorldHelper.isBlock(this.controller, this.position.m_122024_(), Blocks.f_50016_)) {
            this.setDebugState("Clearing area on west side...");
            return new DestroyBlockTask(this.position.m_122024_());
        }
        if (!WorldHelper.isBlock(this.controller, this.position.m_6630_(2), Blocks.f_50016_)) {
            this.setDebugState("Destroying block in way of pumpkin");
            return new DestroyBlockTask(this.position.m_6630_(2));
        }
        this.canBeFinished = true;
        this.setDebugState("Placing the pumpkin (I think)");
        return new PlaceBlockTask(this.position.m_6630_(2), Blocks.f_50143_);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritoneSettings().blocksToAvoidBreaking.get().remove(Blocks.f_50075_);
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructIronGolemTask;
    }

    @Override
    public boolean isFinished() {
        if (this.position == null) {
            return false;
        }
        Optional<Entity> closestIronGolem = this.controller.getEntityTracker().getClosestEntity(new Vec3((double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_()), IronGolem.class);
        return closestIronGolem.isPresent() && closestIronGolem.get().m_20183_().m_123314_((Vec3i)this.position, 2.0) && this.canBeFinished;
    }

    @Override
    protected String toDebugString() {
        return "Construct Iron Golem";
    }

    private int ironBlocksNeeded(PlayerEngineController mod) {
        if (this.position == null) {
            return 4;
        }
        int needed = 0;
        if (mod.getWorld().m_8055_(this.position).m_60734_() != Blocks.f_50075_) {
            ++needed;
        }
        if (mod.getWorld().m_8055_(this.position.m_7494_().m_122024_()).m_60734_() != Blocks.f_50075_) {
            ++needed;
        }
        if (mod.getWorld().m_8055_(this.position.m_7494_().m_122029_()).m_60734_() != Blocks.f_50075_) {
            ++needed;
        }
        if (mod.getWorld().m_8055_(this.position.m_7494_()).m_60734_() != Blocks.f_50075_) {
            ++needed;
        }
        return needed;
    }

    private ItemTarget[] golemMaterials(PlayerEngineController mod) {
        ItemTarget[] itemTargetArray;
        if (this.position != null && mod.getWorld().m_8055_(this.position.m_6630_(2)).m_60734_() == Blocks.f_50143_) {
            ItemTarget[] itemTargetArray2 = new ItemTarget[1];
            itemTargetArray = itemTargetArray2;
            itemTargetArray2[0] = new ItemTarget(Items.f_41913_, this.ironBlocksNeeded(mod));
        } else {
            ItemTarget[] itemTargetArray3 = new ItemTarget[2];
            itemTargetArray3[0] = new ItemTarget(Items.f_41913_, this.ironBlocksNeeded(mod));
            itemTargetArray = itemTargetArray3;
            itemTargetArray3[1] = new ItemTarget(Items.f_42047_, 1);
        }
        return itemTargetArray;
    }
}

