/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class StoreInContainerTask
extends Task {
    public static final Block[] CONTAINER_BLOCKS = (Block[])Stream.concat(Arrays.stream(new Block[]{Blocks.f_50087_, Blocks.f_50325_, Blocks.f_50618_}), Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.SHULKER_BOXES))).toArray(Block[]::new);
    private final BlockPos containerPos;
    private final boolean getIfNotPresent;
    private final ItemTarget[] toStore;

    public StoreInContainerTask(BlockPos targetContainer, boolean getIfNotPresent, ItemTarget ... toStore) {
        this.containerPos = targetContainer;
        this.getIfNotPresent = getIfNotPresent;
        this.toStore = toStore;
    }

    @Override
    protected void onStart() {
        for (ItemTarget target : this.toStore) {
            this.controller.getBehaviour().addProtectedItems(target.getMatches());
        }
    }

    @Override
    protected Task onTick() {
        if (this.isFinished()) {
            return null;
        }
        if (this.getIfNotPresent) {
            for (ItemTarget target : this.toStore) {
                int needed = target.getTargetCount();
                if (this.controller.getItemStorage().getItemCount(target) >= needed) continue;
                this.setDebugState("Collecting " + String.valueOf(target) + " first.");
                return TaskCatalogue.getItemTask(target);
            }
        }
        if (!this.containerPos.m_123314_(new Vec3i((int)this.controller.getEntity().m_20182_().f_82479_, (int)this.controller.getEntity().m_20182_().f_82480_, (int)this.controller.getEntity().m_20182_().f_82481_), 4.5)) {
            this.setDebugState("Going to container");
            return new GetToBlockTask(this.containerPos);
        }
        BlockEntity blockEntity = this.controller.getWorld().m_7702_(this.containerPos);
        if (!(blockEntity instanceof RandomizableContainerBlockEntity)) {
            Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
            return null;
        }
        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
        RandomizableContainerBlockEntity var19 = container;
        LivingEntityInventory var20 = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        this.controller.getItemStorage().containers.WritableCache(this.controller, this.containerPos);
        this.setDebugState("Storing items");
        for (ItemTarget targetx : this.toStore) {
            int currentInContainer = this.countItem((Container)var19, targetx);
            if (currentInContainer >= targetx.getTargetCount()) continue;
            int neededInContainer = targetx.getTargetCount() - currentInContainer;
            for (int i = 0; i < var20.m_6643_(); ++i) {
                ItemStack remainder;
                int moved;
                ItemStack playerStack = var20.m_8020_(i);
                if (!targetx.matches(playerStack.m_41720_())) continue;
                int toMove = Math.min(neededInContainer, playerStack.m_41613_());
                ItemStack toInsert = playerStack.m_41777_();
                toInsert.m_41764_(toMove);
                if (this.insertStack((Container)var19, toInsert, true).m_41613_() == toInsert.m_41613_() || (moved = toMove - (remainder = this.insertStack((Container)var19, toInsert, false)).m_41613_()) <= 0) continue;
                playerStack.m_41774_(moved);
                var20.m_6836_(i, playerStack);
                container.m_6596_();
                this.controller.getItemStorage().registerSlotAction();
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isFinished() {
        boolean bl;
        BlockEntity blockEntity = this.controller.getWorld().m_7702_(this.containerPos);
        if (blockEntity instanceof Container) {
            Container containerInv = (Container)blockEntity;
            bl = Arrays.stream(this.toStore).allMatch(target -> this.countItem(containerInv, (ItemTarget)target) >= target.getTargetCount());
        } else {
            bl = Arrays.stream(this.toStore).allMatch(target -> this.controller.getItemStorage().getItemCount((ItemTarget)target) == 0);
        }
        return bl;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof StoreInContainerTask)) {
            bl = false;
        } else {
            StoreInContainerTask task = (StoreInContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && task.getIfNotPresent == this.getIfNotPresent && Arrays.equals(task.toStore, this.toStore);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Storing in container[" + this.containerPos.m_123344_() + "] " + Arrays.toString(this.toStore);
    }

    private int countItem(Container inventory, ItemTarget target) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!target.matches(stack.m_41720_())) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private ItemStack insertStack(Container inventory, ItemStack stack, boolean simulate) {
        if (simulate) {
            stack = stack.m_41777_();
        }
        for (int i = 0; i < inventory.m_6643_() && !stack.m_41619_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack)) continue;
            int space = slotStack.m_41741_() - slotStack.m_41613_();
            int toTransfer = Math.min(stack.m_41613_(), space);
            if (toTransfer <= 0) continue;
            slotStack.m_41769_(toTransfer);
            stack.m_41774_(toTransfer);
            if (simulate) continue;
            inventory.m_6836_(i, slotStack);
        }
        for (int ix = 0; ix < inventory.m_6643_() && !stack.m_41619_(); ++ix) {
            if (!inventory.m_8020_(ix).m_41619_()) continue;
            if (!simulate) {
                inventory.m_6836_(ix, stack.m_41777_());
            }
            stack.m_41764_(0);
        }
        return stack;
    }
}

