/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import java.util.Arrays;
import net.minecraft.world.item.Item;

public class EquipArmorTask
extends Task {
    private final ItemTarget[] toEquip;

    public EquipArmorTask(ItemTarget ... toEquip) {
        this.toEquip = toEquip;
    }

    public EquipArmorTask(Item ... toEquip) {
        this((ItemTarget[])Arrays.stream(toEquip).map(ItemTarget::new).toArray(ItemTarget[]::new));
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        ItemTarget[] armorNotPresent = (ItemTarget[])Arrays.stream(this.toEquip).filter(targetx -> !this.controller.getItemStorage().hasItem(targetx.getMatches()) && !StorageHelper.isArmorEquipped(this.controller, targetx.getMatches())).toArray(ItemTarget[]::new);
        if (armorNotPresent.length > 0) {
            this.setDebugState("Obtaining armor to equip.");
            return new CataloguedResourceTask(armorNotPresent);
        }
        this.setDebugState("Equipping armor.");
        for (ItemTarget target : this.toEquip) {
            if (StorageHelper.isArmorEquipped(this.controller, target.getMatches())) continue;
            this.controller.getSlotHandler().forceEquipArmor(this.controller, target);
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return Arrays.stream(this.toEquip).allMatch(target -> StorageHelper.isArmorEquipped(this.controller, target.getMatches()));
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof EquipArmorTask) {
            EquipArmorTask task = (EquipArmorTask)other;
            bl = Arrays.equals(task.toEquip, this.toEquip);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Equipping armor: " + Arrays.toString(this.toEquip);
    }
}

