/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.control.InputControls;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;

public abstract class CustomBaritoneGoalTask
extends Task
implements ITaskRequiresGrounded {
    private final Task wanderTask = new TimeoutWanderTask(5.0f, true);
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final boolean wander;
    protected MovementProgressChecker checker = new MovementProgressChecker();
    protected Goal cachedGoal = null;
    Block[] annoyingBlocks = new Block[]{Blocks.f_50191_, Blocks.f_50694_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50703_, Blocks.f_50155_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_50359_, Blocks.f_50034_, Blocks.f_50685_};
    private Task unstuckTask = null;

    public CustomBaritoneGoalTask(boolean wander) {
        this.wander = wander;
    }

    public CustomBaritoneGoalTask() {
        this(true);
    }

    private static BlockPos[] generateSides(BlockPos pos) {
        return new BlockPos[]{pos.m_7918_(1, 0, 0), pos.m_7918_(-1, 0, 0), pos.m_7918_(0, 0, 1), pos.m_7918_(0, 0, -1), pos.m_7918_(1, 0, -1), pos.m_7918_(1, 0, 1), pos.m_7918_(-1, 0, -1), pos.m_7918_(-1, 0, 1)};
    }

    private boolean isAnnoying(PlayerEngineController mod, BlockPos pos) {
        int b = 0;
        Block[] arrayOfBlock = this.annoyingBlocks;
        int i = arrayOfBlock.length;
        if (b >= i) {
            return false;
        }
        Block AnnoyingBlocks = arrayOfBlock[b];
        return mod.getWorld().m_8055_(pos).m_60734_() == AnnoyingBlocks || mod.getWorld().m_8055_(pos).m_60734_() instanceof DoorBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FenceBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FenceGateBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FlowerBlock;
    }

    private BlockPos stuckInBlock(PlayerEngineController mod) {
        BlockPos[] toCheckHigh;
        BlockPos[] toCheck;
        BlockPos p = mod.getPlayer().m_20183_();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.m_7494_())) {
            return p.m_7494_();
        }
        for (BlockPos check : toCheck = CustomBaritoneGoalTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (BlockPos checkx : toCheckHigh = CustomBaritoneGoalTask.generateSides(p.m_7494_())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.checker.reset();
        this.stuckCheck.reset();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        InputControls controls = mod.getInputControls();
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.checker.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                controls.hold(Input.SNEAK);
                controls.hold(Input.MOVE_FORWARD);
                return null;
            }
            controls.release(Input.SNEAK);
            controls.release(Input.MOVE_BACK);
            controls.release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            controls.release(Input.SNEAK);
            controls.release(Input.MOVE_BACK);
            controls.release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.checker.check(mod) || !this.stuckCheck.check(mod)) {
            BlockPos blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            if (this.stuckCheck.lastBreakingBlock != null) {
                mod.getBaritone().getCustomGoalProcess().setGoalAndPath(this.cachedGoal);
            }
            this.stuckCheck.reset();
        }
        if (this.cachedGoal == null) {
            this.cachedGoal = this.newGoal(mod);
        }
        if (this.wander) {
            if (this.isFinished()) {
                this.checker.reset();
            } else {
                if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
                    this.setDebugState("Wandering...");
                    this.checker.reset();
                    return this.wanderTask;
                }
                if (!this.checker.check(mod)) {
                    Debug.logMessage("Failed to make progress on goal, wandering.");
                    this.onWander(mod);
                    return this.wanderTask;
                }
            }
        }
        if (!mod.getBaritone().getCustomGoalProcess().isActive() && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
            mod.getBaritone().getCustomGoalProcess().setGoalAndPath(this.cachedGoal);
        }
        this.setDebugState("Completing goal.");
        return null;
    }

    @Override
    public boolean isFinished() {
        if (this.cachedGoal == null) {
            this.cachedGoal = this.newGoal(this.controller);
        }
        return this.cachedGoal != null && this.cachedGoal.isInGoal(this.controller.getPlayer().m_20183_());
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
    }

    protected abstract Goal newGoal(PlayerEngineController var1);

    protected void onWander(PlayerEngineController mod) {
    }
}

