/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalXZ;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.core.BlockPos;

public class GetToXZTask
extends CustomBaritoneGoalTask {
    private final int x;
    private final int z;
    private final Dimension dimension;

    public GetToXZTask(int x, int z) {
        this(x, z, null);
    }

    public GetToXZTask(int x, int z, Dimension dimension) {
        this.x = x;
        this.z = z;
        this.dimension = dimension;
    }

    @Override
    protected Task onTick() {
        return this.dimension != null && WorldHelper.getCurrentDimension(this.controller) != this.dimension ? new DefaultGoToDimensionTask(this.dimension) : super.onTick();
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new GoalXZ(this.x, this.z);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof GetToXZTask)) {
            bl = false;
        } else {
            GetToXZTask task = (GetToXZTask)other;
            bl = task.x == this.x && task.z == this.z && task.dimension == this.dimension;
        }
        return bl;
    }

    @Override
    public boolean isFinished() {
        BlockPos cur = this.controller.getPlayer().m_20183_();
        return cur.m_123341_() == this.x && cur.m_123343_() == this.z && (this.dimension == null || this.dimension == WorldHelper.getCurrentDimension(this.controller));
    }

    @Override
    protected String toDebugString() {
        return "Getting to (" + this.x + "," + this.z + ")" + (String)(this.dimension != null ? " in dimension " + String.valueOf((Object)this.dimension) : "");
    }
}

