/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.MiningRequirement;
import java.util.Arrays;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectBlockByOneTask
extends ResourceTask {
    private final Item item;
    private final Block[] blocks;
    private final MiningRequirement requirement;
    private final int count;

    public CollectBlockByOneTask(Item item, Block[] blocks, MiningRequirement requirement, int targetCount) {
        super(item, targetCount);
        this.item = item;
        this.blocks = blocks;
        this.requirement = requirement;
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        return new MineAndCollectTask(this.item, this.count, this.blocks, this.requirement);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (!(other instanceof CollectBlockByOneTask)) {
            bl = false;
        } else {
            CollectBlockByOneTask task = (CollectBlockByOneTask)other;
            bl = task.count == this.count && task.item.equals(this.item) && Arrays.stream(task.blocks).allMatch(block -> Arrays.stream(this.blocks).toList().contains(block));
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + String.valueOf(this.item);
    }

    public static class CollectEndStoneTask
    extends CollectBlockByOneTask {
        public CollectEndStoneTask(int targetCount) {
            super(Items.f_42102_, new Block[]{Blocks.f_50259_}, MiningRequirement.WOOD, targetCount);
        }
    }

    public static class CollectCobblestoneTask
    extends CollectBlockByOneTask {
        public CollectCobblestoneTask(int targetCount) {
            super(Items.f_42594_, new Block[]{Blocks.f_50069_, Blocks.f_50652_}, MiningRequirement.WOOD, targetCount);
        }
    }

    public static class CollectCobbledDeepslateTask
    extends CollectBlockByOneTask {
        public CollectCobbledDeepslateTask(int targetCount) {
            super(Items.f_151035_, new Block[]{Blocks.f_152550_, Blocks.f_152551_}, MiningRequirement.WOOD, targetCount);
        }
    }
}

