/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectBucketLiquidTask
extends ResourceTask {
    private final HashSet<BlockPos> blacklist = new HashSet();
    private final TimerGame tryImmediatePickupTimer = new TimerGame(3.0);
    private final TimerGame pickedUpTimer = new TimerGame(0.5);
    private final int count;
    private final Item target;
    private final Block toCollect;
    private final String liquidName;
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private boolean wasWandering = false;
    int tries = 0;
    TimerGame timeoutTimer = new TimerGame(2.0);

    public CollectBucketLiquidTask(String liquidName, Item filledBucket, int targetCount, Block toCollect) {
        super(filledBucket, targetCount);
        this.liquidName = liquidName;
        this.target = filledBucket;
        this.count = targetCount;
        this.toCollect = toCollect;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().setRayTracingFluidHandling(ClipContext.Fluid.SOURCE_ONLY);
        mod.getBehaviour().avoidBlockBreaking(pos -> this.controller.getWorld().m_8055_(pos).m_60734_() == this.toCollect);
        mod.getBehaviour().avoidBlockPlacing(pos -> this.controller.getWorld().m_8055_(pos).m_60734_() == this.toCollect);
        mod.getBaritoneSettings().avoidUpdatingFallingBlocks.set(Boolean.TRUE);
        this.progressChecker.reset();
    }

    @Override
    protected Task onTick() {
        Task result = super.onTick();
        if (!this.thisOrChildAreTimedOut()) {
            this.wasWandering = false;
        }
        return result;
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Block standingInside;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (this.tryImmediatePickupTimer.elapsed() && !mod.getItemStorage().hasItem(Items.f_42447_) && (standingInside = mod.getWorld().m_8055_(mod.getPlayer().m_20183_()).m_60734_()) == this.toCollect && WorldHelper.isSourceBlock(this.controller, mod.getPlayer().m_20183_(), false)) {
            this.setDebugState("Trying to collect (we are in it)");
            mod.getInputControls().forceLook(0.0f, 90.0f);
            this.tryImmediatePickupTimer.reset();
            if (mod.getSlotHandler().forceEquipItem(Items.f_42446_)) {
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                mod.getExtraBaritoneSettings().setInteractionPaused(true);
                this.pickedUpTimer.reset();
                this.progressChecker.reset();
            }
            return null;
        }
        if (!this.pickedUpTimer.elapsed()) {
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
            this.progressChecker.reset();
            return null;
        }
        int bucketsNeeded = this.count - mod.getItemStorage().getItemCount(Items.f_42446_) - mod.getItemStorage().getItemCount(this.target);
        if (bucketsNeeded > 0) {
            this.setDebugState("Getting bucket...");
            return TaskCatalogue.getItemTask(Items.f_42446_, bucketsNeeded);
        }
        Predicate<BlockPos> isSafeSourceLiquid = blockPos -> {
            if (this.blacklist.contains(blockPos)) {
                return false;
            }
            if (!WorldHelper.canReach(this.controller, blockPos)) {
                return false;
            }
            if (!WorldHelper.canReach(this.controller, blockPos.m_7494_())) {
                return false;
            }
            assert (this.controller.getWorld() != null);
            Block above = mod.getWorld().m_8055_(blockPos.m_7494_()).m_60734_();
            if (above != Blocks.f_50752_ && above != Blocks.f_49990_) {
                for (Direction direction : Direction.values()) {
                    if (direction.m_122434_().m_122478_() || mod.getWorld().m_8055_(blockPos.m_7494_().m_121945_(direction)).m_60734_() != Blocks.f_49990_) continue;
                    return false;
                }
                return WorldHelper.isSourceBlock(this.controller, blockPos, false);
            }
            return false;
        };
        if (mod.getBlockScanner().anyFound(isSafeSourceLiquid, this.toCollect)) {
            this.setDebugState("Trying to collect...");
            return new DoToClosestBlockTask(blockPos -> {
                if (mod.getWorld().m_8055_(blockPos.m_7494_()).m_280296_()) {
                    if (!this.progressChecker.check(mod)) {
                        mod.getBaritone().getPathingBehavior().cancelEverything();
                        mod.getBaritone().getPathingBehavior().forceCancel();
                        mod.getBaritone().getExploreProcess().onLostControl();
                        mod.getBaritone().getCustomGoalProcess().onLostControl();
                        Debug.logMessage("Failed to break, blacklisting.");
                        mod.getBlockScanner().requestBlockUnreachable((BlockPos)blockPos);
                        this.blacklist.add((BlockPos)blockPos);
                    }
                    return new DestroyBlockTask(blockPos.m_7494_());
                }
                if (this.tries > 75) {
                    if (this.timeoutTimer.elapsed()) {
                        this.tries = 0;
                    }
                    mod.log("trying to wander " + this.timeoutTimer.getDuration());
                    return new TimeoutWanderTask();
                }
                this.timeoutTimer.reset();
                if (LookHelper.getReach(this.controller, blockPos).isPresent() && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
                    ++this.tries;
                    return new InteractWithBlockTask(new ItemTarget(Items.f_42446_, 1), (BlockPos)blockPos, this.toCollect != Blocks.f_49991_, new Vec3i(0, 1, 0));
                }
                if (this.thisOrChildAreTimedOut() && !this.wasWandering) {
                    mod.getBlockScanner().requestBlockUnreachable(blockPos.m_7494_());
                    this.wasWandering = true;
                }
                return new GetCloseToBlockTask(blockPos.m_7494_());
            }, isSafeSourceLiquid, this.toCollect);
        }
        if (this.toCollect == Blocks.f_49990_ && WorldHelper.getCurrentDimension(this.controller) == Dimension.NETHER) {
            return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
        }
        this.setDebugState("Searching for liquid by wandering around aimlessly");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
        mod.getExtraBaritoneSettings().setInteractionPaused(false);
        mod.getBaritoneSettings().avoidUpdatingFallingBlocks.set(false);
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        if (other instanceof CollectBucketLiquidTask) {
            CollectBucketLiquidTask task = (CollectBucketLiquidTask)other;
            return task.count != this.count ? false : task.toCollect == this.toCollect;
        }
        return false;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " " + this.liquidName + " buckets";
    }

    public static class CollectWaterBucketTask
    extends CollectBucketLiquidTask {
        public CollectWaterBucketTask(int targetCount) {
            super("water", Items.f_42447_, targetCount, Blocks.f_49990_);
        }
    }

    public static class CollectLavaBucketTask
    extends CollectBucketLiquidTask {
        public CollectLavaBucketTask(int targetCount) {
            super("lava", Items.f_42448_, targetCount, Blocks.f_49991_);
        }
    }
}

