/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectGoldNuggetsTask
extends ResourceTask {
    private final int count;

    public CollectGoldNuggetsTask(int count) {
        super(Items.f_42587_, count);
        this.count = count;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        switch (WorldHelper.getCurrentDimension(this.controller).ordinal()) {
            case 1: {
                this.setDebugState("Getting gold ingots to convert to nuggets");
                int potentialNuggies = mod.getItemStorage().getItemCount(Items.f_42587_) + mod.getItemStorage().getItemCount(Items.f_42417_) * 9;
                if (potentialNuggies >= this.count && mod.getItemStorage().hasItem(Items.f_42417_)) {
                    return new CraftInInventoryTask(new RecipeTarget(Items.f_42587_, this.count, CraftingRecipe.newShapedRecipe("golden_nuggets", new ItemTarget[]{new ItemTarget(Items.f_42417_, 1), null, null, null}, 9)));
                }
                int nuggiesStillNeeded = this.count - potentialNuggies;
                return TaskCatalogue.getItemTask(Items.f_42417_, (int)Math.ceil((double)nuggiesStillNeeded / 9.0));
            }
            case 2: {
                this.setDebugState("Mining nuggies");
                return new MineAndCollectTask(Items.f_42587_, this.count, new Block[]{Blocks.f_49998_, Blocks.f_50706_}, MiningRequirement.WOOD);
            }
            case 3: {
                this.setDebugState("Going to overworld");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
        }
        this.setDebugState("INVALID DIMENSION??: " + String.valueOf((Object)WorldHelper.getCurrentDimension(this.controller)));
        return null;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectGoldNuggetsTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " nuggets";
    }
}

