/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.SmeltInSmokerTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CollectMeatTask
extends Task {
    public static final CollectFoodTask.CookableFoodTarget[] COOKABLE_MEATS = new CollectFoodTask.CookableFoodTarget[]{new CollectFoodTask.CookableFoodTarget("beef", Cow.class), new CollectFoodTask.CookableFoodTarget("porkchop", Pig.class), new CollectFoodTask.CookableFoodTarget("chicken", Chicken.class), new CollectFoodTask.CookableFoodTarget("mutton", Sheep.class), new CollectFoodTask.CookableFoodTarget("rabbit", Rabbit.class)};
    private static final double NEARBY_PICKUP_RADIUS = 15.0;
    private final double unitsNeeded;
    private final TimerGame checkNewOptionsTimer = new TimerGame(10.0);
    private Task currentResourceTask = null;

    public CollectMeatTask(double unitsNeeded) {
        this.unitsNeeded = unitsNeeded;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        for (CollectFoodTask.CookableFoodTarget meat : COOKABLE_MEATS) {
            this.controller.getBehaviour().addProtectedItems(meat.getRaw(), meat.getCooked());
        }
    }

    @Override
    protected Task onTick() {
        SmeltTarget toSmelt;
        CollectFoodTask.blackListChickenJockeys(this.controller);
        double potentialFood = CollectMeatTask.calculateFoodPotential(this.controller);
        if (potentialFood >= this.unitsNeeded && (toSmelt = this.getBestSmeltTarget(this.controller)) != null) {
            this.setDebugState("Cooking meat");
            return new SmeltInSmokerTask(toSmelt);
        }
        if (this.checkNewOptionsTimer.elapsed()) {
            this.checkNewOptionsTimer.reset();
            this.currentResourceTask = null;
        }
        if (this.currentResourceTask != null && this.currentResourceTask.isActive() && !this.currentResourceTask.isFinished() && !this.currentResourceTask.thisOrChildAreTimedOut()) {
            return this.currentResourceTask;
        }
        Item[] allMeats = (Item[])Arrays.stream(COOKABLE_MEATS).flatMap(meat -> Stream.of(meat.getRaw(), meat.getCooked())).toArray(Item[]::new);
        Optional<ItemEntity> closestDrop = this.controller.getEntityTracker().getClosestItemDrop(this.controller.getPlayer().m_20182_(), allMeats);
        if (closestDrop.isPresent() && (double)closestDrop.get().m_20270_((Entity)this.controller.getPlayer()) < 15.0) {
            this.setDebugState("Picking up nearby dropped meat");
            this.currentResourceTask = new PickupDroppedItemTask(new ItemTarget(allMeats, 9999), true);
            return this.currentResourceTask;
        }
        Entity bestEntityToKill = this.getBestAnimalToKill(this.controller);
        if (bestEntityToKill != null) {
            this.setDebugState("Hunting " + bestEntityToKill.m_6095_().m_20676_().getString());
            Item rawFood = Arrays.stream(COOKABLE_MEATS).filter(c -> c.mobToKill == bestEntityToKill.getClass()).findFirst().get().getRaw();
            this.currentResourceTask = new KillAndLootTask(bestEntityToKill.getClass(), new ItemTarget(rawFood, 1));
            return this.currentResourceTask;
        }
        this.setDebugState("Searching for animals...");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    public boolean isFinished() {
        double currentFoodScore = 0.0;
        for (CollectFoodTask.CookableFoodTarget meat : COOKABLE_MEATS) {
            currentFoodScore += (double)(this.controller.getItemStorage().getItemCount(meat.getCooked()) * meat.getCookedUnits());
        }
        return currentFoodScore >= this.unitsNeeded;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof CollectMeatTask) {
            CollectMeatTask task = (CollectMeatTask)other;
            bl = task.unitsNeeded == this.unitsNeeded;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Collecting " + this.unitsNeeded + " units of meat.";
    }

    private SmeltTarget getBestSmeltTarget(PlayerEngineController controller) {
        for (CollectFoodTask.CookableFoodTarget cookable : COOKABLE_MEATS) {
            int rawCount = controller.getItemStorage().getItemCount(cookable.getRaw());
            if (rawCount <= 0) continue;
            return new SmeltTarget(new ItemTarget(cookable.getCooked(), rawCount), new ItemTarget(cookable.getRaw(), rawCount), new Item[0]);
        }
        return null;
    }

    private Entity getBestAnimalToKill(PlayerEngineController controller) {
        double bestScore = -1.0;
        Entity bestEntity = null;
        Predicate<Entity> notBaby = entity -> entity instanceof LivingEntity && !((LivingEntity)entity).m_6162_();
        for (CollectFoodTask.CookableFoodTarget cookable : COOKABLE_MEATS) {
            double score;
            double distanceSq;
            Optional<Entity> nearest;
            if (!controller.getEntityTracker().entityFound(cookable.mobToKill) || !(nearest = controller.getEntityTracker().getClosestEntity(controller.getEntity().m_20182_(), notBaby, cookable.mobToKill)).isPresent() || (distanceSq = nearest.get().m_20182_().m_82557_(controller.getEntity().m_20182_())) == 0.0 || !((score = (double)cookable.getCookedUnits() / distanceSq) > bestScore)) continue;
            bestScore = score;
            bestEntity = nearest.get();
        }
        return bestEntity;
    }

    private static double calculateFoodPotential(PlayerEngineController controller) {
        double potentialFood = 0.0;
        for (ItemStack stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            potentialFood += CollectMeatTask.getFoodPotential(stack);
        }
        return potentialFood;
    }

    public static double getFoodPotential(ItemStack food) {
        if (food != null && !food.m_41619_()) {
            int count = food.m_41613_();
            for (CollectFoodTask.CookableFoodTarget cookable : COOKABLE_MEATS) {
                if (food.m_41720_() == cookable.getRaw()) {
                    return (double)count * (double)cookable.getCookedUnits();
                }
                if (food.m_41720_() != cookable.getCooked()) continue;
                return (double)count * (double)cookable.getCookedUnits();
            }
            return 0.0;
        }
        return 0.0;
    }
}

