/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.ArrayUtils;

public class CollectRecipeCataloguedResourcesTask
extends Task {
    private final RecipeTarget[] targets;
    private final boolean ignoreUncataloguedSlots;
    private boolean finished = false;

    public CollectRecipeCataloguedResourcesTask(boolean ignoreUncataloguedSlots, RecipeTarget ... targets) {
        this.targets = targets;
        this.ignoreUncataloguedSlots = ignoreUncataloguedSlots;
    }

    @Override
    protected void onStart() {
        this.finished = false;
    }

    @Override
    protected Task onTick() {
        int count;
        PlayerEngineController mod = this.controller;
        HashMap<String, Integer> catalogueCount = new HashMap<String, Integer>();
        HashMap<Item, Integer> itemCount = new HashMap<Item, Integer>();
        for (RecipeTarget target : this.targets) {
            int weNeed;
            if (target == null || (weNeed = target.getTargetCount() - mod.getItemStorage().getItemCount(target.getOutputItem())) <= 0) continue;
            CraftingRecipe recipe = target.getRecipe();
            for (int i = 0; i < recipe.getSlotCount(); ++i) {
                ItemTarget slot = recipe.getSlot(i);
                if (slot == null || slot.isEmpty()) continue;
                int numberOfRepeats = (int)Math.floor(-0.1 + (double)weNeed / (double)target.getRecipe().outputCount()) + 1;
                if (!slot.isCatalogueItem()) {
                    if (slot.getMatches().length != 1) {
                        if (this.ignoreUncataloguedSlots) continue;
                        Debug.logWarning("Recipe collection for recipe " + String.valueOf(recipe) + " slot " + i + " is not catalogued. Please define an explicit collectRecipeSubTask() function for this item target:" + String.valueOf(slot));
                        continue;
                    }
                    Item item = slot.getMatches()[0];
                    itemCount.put(item, itemCount.getOrDefault(item, 0) + numberOfRepeats);
                    continue;
                }
                String targetName = slot.getCatalogueName();
                catalogueCount.put(targetName, catalogueCount.getOrDefault(targetName, 0) + numberOfRepeats);
            }
        }
        for (String catalogueMaterialName : catalogueCount.keySet()) {
            count = (Integer)catalogueCount.get(catalogueMaterialName);
            ItemTarget itemTarget = new ItemTarget(catalogueMaterialName, count);
            if (count <= 0 || StorageHelper.itemTargetsMet(mod, itemTarget)) continue;
            this.setDebugState("Getting " + String.valueOf(itemTarget));
            return TaskCatalogue.getItemTask(catalogueMaterialName, count);
        }
        for (Item item : itemCount.keySet()) {
            count = (Integer)itemCount.get(item);
            if (count <= 0 || mod.getItemStorage().getItemCount(item) >= count) continue;
            this.setDebugState("Getting " + item.m_5524_());
            return TaskCatalogue.getItemTask(item, count);
        }
        this.finished = true;
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof CollectRecipeCataloguedResourcesTask) {
            CollectRecipeCataloguedResourcesTask task = (CollectRecipeCataloguedResourcesTask)other;
            bl = Arrays.equals(task.targets, this.targets);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Collect Recipe Resources: " + ArrayUtils.toString((Object)this.targets);
    }

    @Override
    public boolean isFinished() {
        if (this.finished && !StorageHelper.hasRecipeMaterialsOrTarget(this.controller, this.targets)) {
            this.finished = false;
            Debug.logMessage("Invalid collect recipe \"finished\" state, resetting.");
        }
        return this.finished;
    }
}

