/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectSandstoneTask
extends ResourceTask {
    private final int count;

    public CollectSandstoneTask(int targetCount) {
        super(Items.f_41856_, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (mod.getItemStorage().getItemCount(Items.f_41830_) >= 4) {
            int target = mod.getItemStorage().getItemCount(Items.f_41856_) + 1;
            ItemTarget s = new ItemTarget(Items.f_41830_, 1);
            return new CraftInInventoryTask(new RecipeTarget(Items.f_41856_, target, CraftingRecipe.newShapedRecipe("sandstone", new ItemTarget[]{s, s, s, s}, 1)));
        }
        return new MineAndCollectTask(new ItemTarget(Items.f_41856_, Items.f_41830_), new Block[]{Blocks.f_50062_, Blocks.f_49992_}, MiningRequirement.WOOD).forceDimension(Dimension.OVERWORLD);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectSandstoneTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " sandstone.";
    }
}

