/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.utils.Debug;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractDoToEntityTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class TradeWithPiglinsTask
extends ResourceTask {
    private static final boolean AVOID_HOGLINS = true;
    private static final double HOGLIN_AVOID_TRADE_RADIUS = 64.0;
    private static final double TRADING_PIGLIN_TOO_FAR_AWAY = 72.0;
    private final int goldBuffer;
    private final Task tradeTask = new PerformTradeWithPiglin();
    private Task goldTask = null;

    public TradeWithPiglinsTask(int goldBuffer, ItemTarget[] itemTargets) {
        super(itemTargets);
        this.goldBuffer = goldBuffer;
    }

    public TradeWithPiglinsTask(int goldBuffer, ItemTarget target) {
        super(target);
        this.goldBuffer = goldBuffer;
    }

    public TradeWithPiglinsTask(int goldBuffer, Item item, int targetCount) {
        super(item, targetCount);
        this.goldBuffer = goldBuffer;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (this.goldTask != null && this.goldTask.isActive() && !this.goldTask.isFinished()) {
            this.setDebugState("Collecting gold");
            return this.goldTask;
        }
        if (!mod.getItemStorage().hasItem(Items.f_42417_)) {
            if (this.goldTask == null) {
                this.goldTask = TaskCatalogue.getItemTask(Items.f_42417_, this.goldBuffer);
            }
            return this.goldTask;
        }
        if (!mod.getEntityTracker().entityFound(Piglin.class)) {
            this.setDebugState("Wandering");
            return new TimeoutWanderTask(false);
        }
        this.setDebugState("Trading with Piglin");
        return this.tradeTask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof TradeWithPiglinsTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Trading with Piglins";
    }

    static class PerformTradeWithPiglin
    extends AbstractDoToEntityTask {
        private static final double PIGLIN_NEARBY_RADIUS = 10.0;
        private final TimerGame barterTimeout = new TimerGame(2.0);
        private final TimerGame intervalTimeout = new TimerGame(10.0);
        private final HashSet<Entity> blacklisted = new HashSet();
        private Entity currentlyBartering = null;

        public PerformTradeWithPiglin() {
            super(3.0);
        }

        @Override
        protected void onStart() {
            super.onStart();
            PlayerEngineController mod = this.controller;
            mod.getBehaviour().push();
            mod.getBehaviour().addProtectedItems(Items.f_42417_);
            mod.getBehaviour().addForceFieldExclusion(entity -> entity instanceof Piglin ? !this.blacklisted.contains(entity) : false);
        }

        @Override
        protected void onStop(Task interruptTask) {
            super.onStop(interruptTask);
            this.controller.getBehaviour().pop();
        }

        @Override
        protected boolean isSubEqual(AbstractDoToEntityTask other) {
            return other instanceof PerformTradeWithPiglin;
        }

        @Override
        protected Task onEntityInteract(PlayerEngineController mod, Entity entity) {
            Optional<Entity> closestHoglin;
            if (this.intervalTimeout.elapsed()) {
                this.barterTimeout.reset();
                this.intervalTimeout.reset();
            }
            if (EntityHelper.isTradingPiglin(this.currentlyBartering)) {
                this.barterTimeout.reset();
            }
            if (!entity.equals((Object)this.currentlyBartering)) {
                this.currentlyBartering = entity;
                this.barterTimeout.reset();
            }
            if (this.barterTimeout.elapsed()) {
                Debug.logMessage("Failed bartering with current piglin, blacklisting.");
                this.blacklisted.add(this.currentlyBartering);
                this.barterTimeout.reset();
                this.currentlyBartering = null;
                return null;
            }
            if (this.currentlyBartering != null && !EntityHelper.isTradingPiglin(this.currentlyBartering) && (closestHoglin = mod.getEntityTracker().getClosestEntity(this.currentlyBartering.m_20182_(), Hoglin.class)).isPresent() && closestHoglin.get().m_19950_(entity, 64.0)) {
                Debug.logMessage("Aborting further trading because a hoglin showed up");
                this.blacklisted.add(this.currentlyBartering);
                this.barterTimeout.reset();
                this.currentlyBartering = null;
            }
            this.setDebugState("Trading with piglin");
            if (mod.getSlotHandler().forceEquipItem(Items.f_42417_)) {
                Debug.logError("NYI");
                this.intervalTimeout.reset();
            }
            return null;
        }

        @Override
        protected Optional<Entity> getEntityTarget(PlayerEngineController mod) {
            Optional<Entity> found = mod.getEntityTracker().getClosestEntity(mod.getPlayer().m_20182_(), entity -> {
                if (!(this.blacklisted.contains(entity) || EntityHelper.isTradingPiglin(entity) || entity instanceof LivingEntity && ((LivingEntity)entity).m_6162_() || this.currentlyBartering != null && !entity.m_19950_(this.currentlyBartering, 10.0))) {
                    Optional<Entity> closestHoglin = mod.getEntityTracker().getClosestEntity(entity.m_20182_(), Hoglin.class);
                    return closestHoglin.isEmpty() || !closestHoglin.get().m_19950_(entity, 64.0);
                }
                return false;
            }, Piglin.class);
            if (found.isEmpty()) {
                if (this.currentlyBartering != null && (this.blacklisted.contains(this.currentlyBartering) || !this.currentlyBartering.m_6084_())) {
                    this.currentlyBartering = null;
                }
                found = Optional.ofNullable(this.currentlyBartering);
            }
            return found;
        }

        @Override
        protected String toDebugString() {
            return "Trading with piglin";
        }
    }
}

