/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.BotBehaviour;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalRunAway;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AreaEffectCloud;

public class DragonBreathTracker {
    private final HashSet<BlockPos> breathBlocks = new HashSet();

    public void updateBreath(PlayerEngineController mod) {
        this.breathBlocks.clear();
        for (AreaEffectCloud cloud : mod.getEntityTracker().getTrackedEntities(AreaEffectCloud.class)) {
            for (BlockPos bad : WorldHelper.getBlocksTouchingBox(cloud.m_20191_())) {
                this.breathBlocks.add(bad);
            }
        }
    }

    public boolean isTouchingDragonBreath(BlockPos pos) {
        return this.breathBlocks.contains(pos);
    }

    public Task getRunAwayTask() {
        return new RunAwayFromDragonsBreathTask();
    }

    private class RunAwayFromDragonsBreathTask
    extends CustomBaritoneGoalTask {
        private RunAwayFromDragonsBreathTask() {
        }

        @Override
        protected void onStart() {
            super.onStart();
            BotBehaviour botBehaviour = this.controller.getBehaviour();
            botBehaviour.push();
            botBehaviour.setBlockPlacePenalty(Double.POSITIVE_INFINITY);
            this.checker = new MovementProgressChecker(Integer.MAX_VALUE);
        }

        @Override
        protected void onStop(Task interruptTask) {
            super.onStop(interruptTask);
            this.controller.getBehaviour().pop();
        }

        @Override
        protected Goal newGoal(PlayerEngineController mod) {
            return new GoalRunAway(10.0, (BlockPos[])DragonBreathTracker.this.breathBlocks.toArray(BlockPos[]::new));
        }

        @Override
        protected boolean isEqual(Task other) {
            return other instanceof RunAwayFromDragonsBreathTask;
        }

        @Override
        protected String toDebugString() {
            return "ESCAPE Dragons Breath";
        }
    }
}

