/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.util.ChunkController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoadingTracker {
    private List<ChunkPos> chunks = new ArrayList<ChunkPos>();
    private int ticks = 20;
    private long playerLastSeen = -1L;
    private LivingEntity entity;

    public ChunkLoadingTracker(PlayerEngineController controller) {
        this.entity = controller.getEntity();
    }

    public boolean tick() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 20;
        List players = this.entity.m_9236_().m_45976_(Player.class, this.entity.m_20191_().m_82377_(48.0, 48.0, 48.0));
        if (!players.isEmpty()) {
            this.playerLastSeen = System.currentTimeMillis();
        }
        double x = this.entity.m_20185_() / 16.0;
        double z = this.entity.m_20189_() / 16.0;
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        list.add(new ChunkPos(Mth.m_14107_((double)x), Mth.m_14107_((double)z)));
        list.add(new ChunkPos(Mth.m_14165_((double)x), Mth.m_14165_((double)z)));
        list.add(new ChunkPos(Mth.m_14107_((double)x), Mth.m_14165_((double)z)));
        list.add(new ChunkPos(Mth.m_14165_((double)x), Mth.m_14107_((double)z)));
        for (ChunkPos chunk : list) {
            if (!this.chunks.contains(chunk)) {
                ChunkController.instance.load((ServerLevel)this.entity.m_9236_(), this.entity.m_20148_(), chunk.f_45578_, chunk.f_45579_);
            }
            this.chunks.remove(chunk);
        }
        for (ChunkPos chunk : this.chunks) {
            ChunkController.instance.unload((ServerLevel)this.entity.m_9236_(), this.entity.m_20148_(), chunk.f_45578_, chunk.f_45579_);
        }
        this.chunks = list;
        return false;
    }

    public void reset() {
        if (this.entity.m_9236_() instanceof ServerLevel) {
            ChunkController.instance.unload((ServerLevel)this.entity.m_9236_(), this.entity.m_20148_(), this.entity.m_146902_().f_45578_, this.entity.m_146902_().f_45579_);
            this.chunks.clear();
            this.playerLastSeen = 0L;
        }
    }
}

