/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.baritone;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.CachedProjectile;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;

public class GoalDodgeProjectiles
implements Goal {
    private static final double Y_SCALE = (double)0.3f;
    private final PlayerEngineController mod;
    private final double distanceHorizontal;
    private final double distanceVertical;
    private final List<CachedProjectile> cachedProjectiles = new ArrayList<CachedProjectile>();

    public GoalDodgeProjectiles(PlayerEngineController mod, double distanceHorizontal, double distanceVertical) {
        this.mod = mod;
        this.distanceHorizontal = distanceHorizontal;
        this.distanceVertical = distanceVertical;
    }

    private static boolean isInvalidProjectile(CachedProjectile projectile) {
        return projectile == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInGoal(int x, int y, int z) {
        List<CachedProjectile> projectiles = this.getProjectiles();
        Vec3 p = new Vec3((double)x, (double)y, (double)z);
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            if (!projectiles.isEmpty()) {
                for (CachedProjectile projectile : projectiles) {
                    if (GoalDodgeProjectiles.isInvalidProjectile(projectile)) continue;
                    try {
                        Vec3 hit;
                        if (projectile.needsToRecache()) {
                            projectile.setCacheHit(ProjectileHelper.calculateArrowClosestApproach(projectile, p));
                        }
                        if (!this.isHitCloseEnough(hit = projectile.getCachedHit(), p)) continue;
                        return false;
                    }
                    catch (Exception var11) {
                        Debug.logWarning("Weird exception caught while checking for goal: " + var11.getMessage());
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double heuristic(int x, int y, int z) {
        Vec3 p = new Vec3((double)x, (double)y, (double)z);
        double costFactor = 0.0;
        List<CachedProjectile> projectiles = this.getProjectiles();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            if (!projectiles.isEmpty()) {
                for (CachedProjectile projectile : projectiles) {
                    if (GoalDodgeProjectiles.isInvalidProjectile(projectile)) continue;
                    if (projectile.needsToRecache()) {
                        projectile.setCacheHit(ProjectileHelper.calculateArrowClosestApproach(projectile, p));
                    }
                    Vec3 hit = projectile.getCachedHit();
                    double arrowPenalty = ProjectileHelper.getFlatDistanceSqr(projectile.position.f_82479_, projectile.position.f_82481_, projectile.velocity.f_82479_, projectile.velocity.f_82481_, p.f_82479_, p.f_82481_);
                    if (!this.isHitCloseEnough(hit, p)) continue;
                    costFactor += arrowPenalty;
                }
            }
        }
        return -1.0 * costFactor;
    }

    private boolean isHitCloseEnough(Vec3 hit, Vec3 to) {
        Vec3 delta = to.m_82546_(hit);
        double horizontalSquared = delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_;
        double vertical = Math.abs(delta.f_82480_);
        return horizontalSquared < this.distanceHorizontal * this.distanceHorizontal && vertical < this.distanceVertical;
    }

    private List<CachedProjectile> getProjectiles() {
        return this.mod.getEntityTracker().getProjectiles();
    }
}

