/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.utils.ToolSet;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.Pair;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StorageHelper {
    public static ItemStack getItemStackInSlot(Slot slot) {
        return slot != null && !slot.equals(Slot.UNDEFINED) ? slot.getStack() : ItemStack.f_41583_;
    }

    public static ItemStack getItemStackInCursorSlot(PlayerEngineController controller) {
        return controller.getSlotHandler().getCursorStack();
    }

    public static boolean isArmorEquipped(PlayerEngineController controller, Item ... any) {
        for (Item item : any) {
            ItemStack equippedStack;
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                equippedStack = controller.getEntity().m_6844_(armor.m_266204_().m_266308_());
                if (!equippedStack.m_150930_(item)) continue;
                return true;
            }
            if (!(item instanceof ShieldItem) || !(equippedStack = controller.getEntity().m_6844_(EquipmentSlot.OFFHAND)).m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmorEquippedAll(PlayerEngineController controller, Item ... all) {
        return Arrays.stream(all).allMatch(item -> StorageHelper.isArmorEquipped(controller, item));
    }

    public static boolean isItemInOffhand(PlayerEngineController controller, Item item) {
        return controller.getEntity().m_6844_(EquipmentSlot.OFFHAND).m_150930_(item);
    }

    public static boolean isEquipped(PlayerEngineController controller, Item ... items) {
        LivingEntityInventory inv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        return Arrays.stream(items).anyMatch(item -> inv.getMainHandStack().m_150930_(item));
    }

    public static MiningRequirement getCurrentMiningRequirement(PlayerEngineController controller) {
        MiningRequirement[] order;
        for (MiningRequirement check : order = new MiningRequirement[]{MiningRequirement.DIAMOND, MiningRequirement.IRON, MiningRequirement.STONE, MiningRequirement.WOOD}) {
            if (!StorageHelper.miningRequirementMet(controller, check)) continue;
            return check;
        }
        return MiningRequirement.HAND;
    }

    private static boolean h(PlayerEngineController controller, boolean inventoryOnly, Item ... items) {
        return inventoryOnly ? controller.getItemStorage().hasItemInventoryOnly(items) : controller.getItemStorage().hasItem(items);
    }

    private static boolean miningRequirementMetInner(PlayerEngineController controller, boolean inventoryOnly, MiningRequirement requirement) {
        return switch (requirement) {
            case MiningRequirement.HAND -> true;
            case MiningRequirement.WOOD -> {
                if (StorageHelper.h(controller, inventoryOnly, Items.f_42422_) || StorageHelper.h(controller, inventoryOnly, Items.f_42427_) || StorageHelper.h(controller, inventoryOnly, Items.f_42385_) || StorageHelper.h(controller, inventoryOnly, Items.f_42432_) || StorageHelper.h(controller, inventoryOnly, Items.f_42390_) || StorageHelper.h(controller, inventoryOnly, Items.f_42395_)) {
                    yield true;
                }
                yield false;
            }
            case MiningRequirement.STONE -> {
                if (StorageHelper.h(controller, inventoryOnly, Items.f_42427_) || StorageHelper.h(controller, inventoryOnly, Items.f_42385_) || StorageHelper.h(controller, inventoryOnly, Items.f_42432_) || StorageHelper.h(controller, inventoryOnly, Items.f_42390_) || StorageHelper.h(controller, inventoryOnly, Items.f_42395_)) {
                    yield true;
                }
                yield false;
            }
            case MiningRequirement.IRON -> {
                if (StorageHelper.h(controller, inventoryOnly, Items.f_42385_) || StorageHelper.h(controller, inventoryOnly, Items.f_42432_) || StorageHelper.h(controller, inventoryOnly, Items.f_42390_) || StorageHelper.h(controller, inventoryOnly, Items.f_42395_)) {
                    yield true;
                }
                yield false;
            }
            case MiningRequirement.DIAMOND -> {
                if (StorageHelper.h(controller, inventoryOnly, Items.f_42390_) || StorageHelper.h(controller, inventoryOnly, Items.f_42395_)) {
                    yield true;
                }
                yield false;
            }
            default -> {
                Debug.logError("You missed a spot");
                yield false;
            }
        };
    }

    public static boolean miningRequirementMet(PlayerEngineController controller, MiningRequirement requirement) {
        return StorageHelper.miningRequirementMetInner(controller, false, requirement);
    }

    public static boolean miningRequirementMetInventory(PlayerEngineController controller, MiningRequirement requirement) {
        return StorageHelper.miningRequirementMetInner(controller, true, requirement);
    }

    public static Optional<Slot> getBestToolSlot(PlayerEngineController controller, BlockState state) {
        int bestSlot = new ToolSet(controller.getPlayer()).getBestSlot(state.m_60734_(), false);
        return Optional.of(new Slot(controller.getInventory().main, bestSlot));
    }

    public static boolean shouldSaveStack(PlayerEngineController controller, Block block, ItemStack stack) {
        return false;
    }

    public static Optional<Slot> getGarbageSlot(PlayerEngineController controller) {
        LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        int bestScore = Integer.MIN_VALUE;
        Slot bestSlot = null;
        for (int i = 0; i < inventory.main.size(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !ItemHelper.canThrowAwayStack(controller, stack)) continue;
            int score = 0;
            if (controller.getModSettings().isThrowaway(stack.m_41720_())) {
                score += 1000;
            }
            if (stack.m_41613_() < stack.m_41741_()) {
                score += 100;
            }
            if ((score -= stack.m_41613_()) <= bestScore) continue;
            bestScore = score;
            bestSlot = new Slot(inventory.main, i);
        }
        return Optional.ofNullable(bestSlot);
    }

    public static int getBuildingMaterialCount(PlayerEngineController controller) {
        return controller.getItemStorage().getItemCount((Item[])Arrays.stream(controller.getModSettings().getThrowawayItems(controller, true)).filter(item -> item instanceof BlockItem && !item.equals(Items.f_41832_) && !item.equals(Items.f_41830_)).toArray(Item[]::new));
    }

    public static boolean itemTargetsMet(PlayerEngineController controller, ItemTarget ... targetsToMeet) {
        return Arrays.stream(targetsToMeet).allMatch(target -> controller.getItemStorage().getItemCount(target.getMatches()) >= target.getTargetCount());
    }

    public static boolean itemTargetsMetInventory(PlayerEngineController controller, ItemTarget ... targetsToMeet) {
        return Arrays.stream(targetsToMeet).allMatch(target -> controller.getItemStorage().getItemCountInventoryOnly(target.getMatches()) >= target.getTargetCount());
    }

    public static boolean hasRecipeMaterialsOrTarget(PlayerEngineController controller, RecipeTarget ... targets) {
        HashMap<Item, Pair<ItemTarget, Integer>> required = new HashMap<Item, Pair<ItemTarget, Integer>>();
        for (RecipeTarget target : targets) {
            int craftsNeeded = (int)Math.ceil((double)(target.getTargetCount() - controller.getItemStorage().getItemCount(target.getOutputItem())) / (double)target.getRecipe().outputCount());
            if (craftsNeeded <= 0) continue;
            for (ItemTarget ingredient : target.getRecipe().getSlots()) {
                if (ingredient == null || ingredient.isEmpty()) continue;
                Item item = ingredient.getMatches()[0];
                required.put(item, new Pair<ItemTarget, Integer>(ingredient, required.getOrDefault(item, new Pair<ItemTarget, Integer>(ingredient, 0)).getRight() + ingredient.getTargetCount() * craftsNeeded));
            }
        }
        for (Item item : required.keySet()) {
            Pair req = (Pair)required.get(item);
            if (controller.getItemStorage().getItemCount((ItemTarget)req.getLeft()) >= (Integer)req.getRight()) continue;
            return false;
        }
        return true;
    }

    public static int calculateInventoryFoodScore(PlayerEngineController controller) {
        int result = 0;
        for (ItemStack stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            if (!ItemVer.isFood(stack)) continue;
            result += Objects.requireNonNull(ItemVer.getFoodComponent(stack.m_41720_())).getHunger() * stack.m_41613_();
        }
        return result;
    }

    public static double calculateInventoryFuelCount(PlayerEngineController controller) {
        double result = 0.0;
        for (ItemStack stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            if (!controller.getModSettings().isSupportedFuel(stack.m_41720_())) continue;
            result += ItemHelper.getFuelAmount(stack.m_41720_()) * (double)stack.m_41613_();
        }
        return result;
    }

    public static ItemTarget[] getAllInventoryItemsAsTargets(PlayerEngineController controller, Predicate<Slot> accept) {
        ItemStack stack;
        HashMap<Item, Integer> counts = new HashMap<Item, Integer>();
        LivingEntityInventory inv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        for (int i = 0; i < inv.main.size(); ++i) {
            ItemStack stack2;
            Slot slot = new Slot(inv.main, i);
            if (!accept.test(slot) || (stack2 = StorageHelper.getItemStackInSlot(slot)).m_41619_()) continue;
            counts.put(stack2.m_41720_(), counts.getOrDefault(stack2.m_41720_(), 0) + stack2.m_41613_());
        }
        Slot offhandSlot = new Slot(inv.offHand, 0);
        if (accept.test(offhandSlot) && !(stack = StorageHelper.getItemStackInSlot(offhandSlot)).m_41619_()) {
            counts.put(stack.m_41720_(), counts.getOrDefault(stack.m_41720_(), 0) + stack.m_41613_());
        }
        for (int ix = 0; ix < inv.armor.size(); ++ix) {
            ItemStack stack3;
            Slot slot = new Slot(inv.armor, ix);
            if (!accept.test(slot) || (stack3 = StorageHelper.getItemStackInSlot(slot)).m_41619_()) continue;
            counts.put(stack3.m_41720_(), counts.getOrDefault(stack3.m_41720_(), 0) + stack3.m_41613_());
        }
        ItemTarget[] results = new ItemTarget[counts.size()];
        int ixx = 0;
        for (Item item : counts.keySet()) {
            results[ixx++] = new ItemTarget(item, (int)((Integer)counts.get(item)));
        }
        return results;
    }

    public static int getNumberOfThrowawayBlocks(PlayerEngineController mod) {
        int totalBlockThrowaways = 0;
        if (!mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod)).isEmpty()) {
            for (Slot slot : mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod))) {
                ItemStack stack = StorageHelper.getItemStackInSlot(slot);
                if (!ItemHelper.canThrowAwayStack(mod, stack) || !(stack.m_41720_() instanceof BlockItem)) continue;
                totalBlockThrowaways += stack.m_41613_();
            }
        }
        return totalBlockThrowaways;
    }

    public static Optional<Slot> getSlotWithThrowawayBlock(PlayerEngineController mod, boolean limitToHotbar) {
        Iterator var7;
        ArrayList<Slot> throwawayBlockItems = new ArrayList<Slot>();
        int totalBlockThrowaways = 0;
        if (!mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod)).isEmpty()) {
            for (Slot slot : mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod))) {
                ItemStack stack;
                if (Slot.isCursor(slot) || limitToHotbar && (slot.getInventorySlot() > 8 || slot.getInventorySlot() < 0) || !ItemHelper.canThrowAwayStack(mod, stack = StorageHelper.getItemStackInSlot(slot)) || !(stack.m_41720_() instanceof BlockItem)) continue;
                totalBlockThrowaways += stack.m_41613_();
                throwawayBlockItems.add(slot);
            }
        }
        if (!throwawayBlockItems.isEmpty() && (var7 = throwawayBlockItems.iterator()).hasNext()) {
            Slot throwawayBlockItem = (Slot)var7.next();
            return Optional.ofNullable(throwawayBlockItem);
        }
        return Optional.empty();
    }
}

