/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.time;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.mixins.ClientConnectionAccessor;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.time.BaseTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;

public class TimerGame
extends BaseTimer {
    private Connection lastConnection;

    public TimerGame(double intervalSeconds) {
        super(intervalSeconds);
    }

    private static double getTime(Connection connection) {
        return connection == null ? 0.0 : (double)((ClientConnectionAccessor)connection).getTicks() / 20.0;
    }

    @Override
    protected double currentTime() {
        if (!PlayerEngineController.inGame()) {
            Debug.logError("Running game timer while not in game.");
            return 0.0;
        }
        Connection currentConnection = null;
        if (Minecraft.m_91087_().m_91403_() != null) {
            currentConnection = Minecraft.m_91087_().m_91403_().m_104910_();
        }
        if (currentConnection != this.lastConnection) {
            if (this.lastConnection != null) {
                double prevTimeTotal = TimerGame.getTime(this.lastConnection);
                Debug.logInternal("(TimerGame: New connection detected, offsetting by " + prevTimeTotal + " seconds)");
                this.setPrevTimeForce(this.getPrevTime() - prevTimeTotal);
            }
            this.lastConnection = currentConnection;
        }
        return TimerGame.getTime(currentConnection);
    }
}

