/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.utils.IEntityAccessor;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class RayTraceUtils {
    public static ClipContext.Fluid fluidHandling = ClipContext.Fluid.NONE;

    private RayTraceUtils() {
    }

    public static HitResult rayTraceTowards(Entity entity, Rotation rotation, double blockReachDistance) {
        return RayTraceUtils.rayTraceTowards(entity, rotation, blockReachDistance, false);
    }

    public static HitResult rayTraceTowards(Entity entity, Rotation rotation, double blockReachDistance, boolean wouldSneak) {
        Vec3 start = wouldSneak ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.m_20299_(1.0f);
        Vec3 direction = RotationUtils.calcVector3dFromRotation(rotation);
        Vec3 end = start.m_82520_(direction.f_82479_ * blockReachDistance, direction.f_82480_ * blockReachDistance, direction.f_82481_ * blockReachDistance);
        return entity.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, fluidHandling, entity));
    }

    public static Vec3 inferSneakingEyePosition(Entity entity) {
        return new Vec3(entity.m_20185_(), entity.m_20186_() + (double)((IEntityAccessor)entity).automatone$invokeGetEyeHeight(Pose.CROUCHING, entity.m_6972_(Pose.CROUCHING)), entity.m_20189_());
    }
}

