/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final Vec3[] BLOCK_SIDE_MULTIPLIERS = new Vec3[]{new Vec3(0.5, 0.0, 0.5), new Vec3(0.5, 1.0, 0.5), new Vec3(0.5, 0.5, 0.0), new Vec3(0.5, 0.5, 1.0), new Vec3(0.0, 0.5, 0.5), new Vec3(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(BlockPos orig, BlockPos dest) {
        return RotationUtils.calcRotationFromVec3d(new Vec3((double)orig.m_123341_(), (double)orig.m_123342_(), (double)orig.m_123343_()), new Vec3((double)dest.m_123341_(), (double)dest.m_123342_(), (double)dest.m_123343_()));
    }

    public static Rotation wrapAnglesToRelative(Rotation current, Rotation target) {
        return current.yawIsReallyClose(target) ? new Rotation(current.getYaw(), target.getPitch()) : target.subtract(current).normalize().add(current);
    }

    public static Rotation calcRotationFromVec3d(Vec3 orig, Vec3 dest, Rotation current) {
        return RotationUtils.wrapAnglesToRelative(current, RotationUtils.calcRotationFromVec3d(orig, dest));
    }

    public static Rotation calcRotationFromVec3d(Vec3 orig, Vec3 dest) {
        double[] delta = new double[]{orig.f_82479_ - dest.f_82479_, orig.f_82480_ - dest.f_82480_, orig.f_82481_ - dest.f_82481_};
        double yaw = Mth.m_14136_((double)delta[0], (double)(-delta[2]));
        double dist = Math.sqrt(delta[0] * delta[0] + delta[2] * delta[2]);
        double pitch = Mth.m_14136_((double)delta[1], (double)dist);
        return new Rotation((float)(yaw * 57.29577951308232), (float)(pitch * 57.29577951308232));
    }

    public static Vec3 calcVector3dFromRotation(Rotation rotation) {
        float f = Mth.m_14089_((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Optional<Rotation> reachable(IEntityContext ctx, BlockPos pos) {
        return RotationUtils.reachable(ctx.entity(), pos, ctx.playerController().getBlockReachDistance());
    }

    public static Optional<Rotation> reachable(IEntityContext ctx, BlockPos pos, boolean wouldSneak) {
        return RotationUtils.reachable(ctx.entity(), pos, ctx.playerController().getBlockReachDistance(), wouldSneak);
    }

    public static Optional<Rotation> reachable(LivingEntity entity, BlockPos pos, double blockReachDistance) {
        return RotationUtils.reachable(entity, pos, blockReachDistance, false);
    }

    public static Optional<Rotation> reachable(LivingEntity entity, BlockPos pos, double blockReachDistance, boolean wouldSneak) {
        Optional<Rotation> possibleRotation;
        IBaritone baritone = BaritoneAPI.getProvider().getBaritone(entity);
        if (baritone.getEntityContext().isLookingAt(pos)) {
            Rotation hypothetical = new Rotation(entity.m_146908_(), entity.m_146909_() + 1.0E-4f);
            if (!wouldSneak) {
                return Optional.of(hypothetical);
            }
            HitResult result = RayTraceUtils.rayTraceTowards((Entity)entity, hypothetical, blockReachDistance, true);
            if (result != null && result.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)result).m_82425_().equals((Object)pos)) {
                return Optional.of(hypothetical);
            }
        }
        if ((possibleRotation = RotationUtils.reachableCenter((Entity)entity, pos, blockReachDistance, wouldSneak)).isPresent()) {
            return possibleRotation;
        }
        BlockState state = entity.m_9236_().m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)entity.m_9236_(), pos);
        if (shape.m_83281_()) {
            shape = Shapes.m_83144_();
        }
        for (Vec3 sideOffset : BLOCK_SIDE_MULTIPLIERS) {
            double xDiff = shape.m_83288_(Direction.Axis.X) * sideOffset.f_82479_ + shape.m_83297_(Direction.Axis.X) * (1.0 - sideOffset.f_82479_);
            double yDiff = shape.m_83288_(Direction.Axis.Y) * sideOffset.f_82480_ + shape.m_83297_(Direction.Axis.Y) * (1.0 - sideOffset.f_82480_);
            double zDiff = shape.m_83288_(Direction.Axis.Z) * sideOffset.f_82481_ + shape.m_83297_(Direction.Axis.Z) * (1.0 - sideOffset.f_82481_);
            possibleRotation = RotationUtils.reachableOffset((Entity)entity, pos, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(xDiff, yDiff, zDiff), blockReachDistance, wouldSneak);
            if (!possibleRotation.isPresent()) continue;
            return possibleRotation;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(Entity entity, BlockPos pos, Vec3 offsetPos, double blockReachDistance, boolean wouldSneak) {
        Vec3 eyes = wouldSneak ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.m_20299_(1.0f);
        Rotation rotation = RotationUtils.calcRotationFromVec3d(eyes, offsetPos, new Rotation(entity.m_146908_(), entity.m_146909_()));
        HitResult result = RayTraceUtils.rayTraceTowards(entity, rotation, blockReachDistance, wouldSneak);
        if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
            if (((BlockHitResult)result).m_82425_().equals((Object)pos)) {
                return Optional.of(rotation);
            }
            if (entity.m_9236_().m_8055_(pos).m_60734_() instanceof BaseFireBlock && ((BlockHitResult)result).m_82425_().equals((Object)pos.m_7495_())) {
                return Optional.of(rotation);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(Entity entity, BlockPos pos, double blockReachDistance, boolean wouldSneak) {
        return RotationUtils.reachableOffset(entity, pos, VecUtils.calculateBlockCenter(entity.m_9236_(), pos), blockReachDistance, wouldSneak);
    }
}

