/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VecUtils {
    private VecUtils() {
    }

    public static Vec3 calculateBlockCenter(Level world, BlockPos pos) {
        BlockState b = world.m_8055_(pos);
        VoxelShape shape = b.m_60812_((BlockGetter)world, pos);
        if (shape.m_83281_()) {
            return VecUtils.getBlockPosCenter(pos);
        }
        double xDiff = (shape.m_83288_(Direction.Axis.X) + shape.m_83297_(Direction.Axis.X)) / 2.0;
        double yDiff = (shape.m_83288_(Direction.Axis.Y) + shape.m_83297_(Direction.Axis.Y)) / 2.0;
        double zDiff = (shape.m_83288_(Direction.Axis.Z) + shape.m_83297_(Direction.Axis.Z)) / 2.0;
        if (!(Double.isNaN(xDiff) || Double.isNaN(yDiff) || Double.isNaN(zDiff))) {
            if (b.m_60734_() instanceof BaseFireBlock) {
                yDiff = 0.0;
            }
            return new Vec3((double)pos.m_123341_() + xDiff, (double)pos.m_123342_() + yDiff, (double)pos.m_123343_() + zDiff);
        }
        throw new IllegalStateException(String.valueOf(b) + " " + String.valueOf(pos) + " " + String.valueOf(shape));
    }

    public static Vec3 getBlockPosCenter(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static double distanceToCenter(BlockPos pos, double x, double y, double z) {
        double xdiff = (double)pos.m_123341_() + 0.5 - x;
        double ydiff = (double)pos.m_123342_() + 0.5 - y;
        double zdiff = (double)pos.m_123343_() + 0.5 - z;
        return Math.sqrt(xdiff * xdiff + ydiff * ydiff + zdiff * zdiff);
    }

    public static double entityDistanceToCenter(Entity entity, BlockPos pos) {
        return VecUtils.distanceToCenter(pos, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public static double entityFlatDistanceToCenter(Entity entity, BlockPos pos) {
        return VecUtils.distanceToCenter(pos, entity.m_20185_(), (double)pos.m_123342_() + 0.5, entity.m_20189_());
    }
}

