/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.behavior;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.behavior.Behavior;
import com.player2.playerengine.automaton.utils.ToolSet;
import java.util.ArrayList;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class InventoryBehavior
extends Behavior {
    public InventoryBehavior(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void onTickServer() {
        LivingEntity livingEntity;
        if (this.baritone.settings().allowInventory.get().booleanValue() && (livingEntity = this.ctx.entity()) instanceof IInventoryProvider) {
            int pick;
            IInventoryProvider player = (IInventoryProvider)livingEntity;
            if (this.firstValidThrowaway(player.getLivingInventory()) >= 9) {
                this.swapWithHotBar(this.firstValidThrowaway(player.getLivingInventory()), 8, player.getLivingInventory());
            }
            if ((pick = this.bestToolAgainst(Blocks.f_50069_, PickaxeItem.class)) >= 9) {
                for (int i = 0; i < 9; ++i) {
                    if (player.getLivingInventory().m_8020_(i).m_41720_() == Items.f_42446_) continue;
                    this.swapWithHotBar(pick, i, player.getLivingInventory());
                    break;
                }
            }
        }
    }

    public void attemptToPutOnHotbar(int inMainInvy, Predicate<Integer> disallowedHotbar, LivingEntityInventory inventory) {
        OptionalInt destination = this.getTempHotbarSlot(disallowedHotbar);
        if (destination.isPresent()) {
            this.swapWithHotBar(inMainInvy, destination.getAsInt(), inventory);
        }
    }

    public OptionalInt getTempHotbarSlot(Predicate<Integer> disallowedHotbar) {
        LivingEntityInventory inventory = this.ctx.inventory();
        if (inventory == null) {
            return OptionalInt.empty();
        }
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i = 1; i < 8; ++i) {
            if (!((ItemStack)inventory.main.get(i)).m_41619_() || disallowedHotbar.test(i)) continue;
            candidates.add(i);
        }
        if (candidates.isEmpty()) {
            for (int ix = 1; ix < 8; ++ix) {
                if (disallowedHotbar.test(ix)) continue;
                candidates.add(ix);
            }
        }
        return candidates.isEmpty() ? OptionalInt.empty() : OptionalInt.of((Integer)candidates.get(new Random().nextInt(candidates.size())));
    }

    private void swapWithHotBar(int inInventory, int inHotbar, LivingEntityInventory inventory) {
        ItemStack h = inventory.m_8020_(inHotbar);
        inventory.m_6836_(inHotbar, inventory.m_8020_(inInventory));
        inventory.m_6836_(inInventory, h);
    }

    private int firstValidThrowaway(LivingEntityInventory inventory) {
        NonNullList<ItemStack> invy = inventory.main;
        for (int i = 0; i < invy.size(); ++i) {
            if (!this.baritone.settings().acceptableThrowawayItems.get().contains(((ItemStack)invy.get(i)).m_41720_())) continue;
            return i;
        }
        return -1;
    }

    private int bestToolAgainst(Block against, Class<? extends TieredItem> cla$$) {
        NonNullList<ItemStack> invy = this.ctx.inventory().main;
        int bestInd = -1;
        double bestSpeed = -1.0;
        for (int i = 0; i < invy.size(); ++i) {
            double speed;
            ItemStack stack = (ItemStack)invy.get(i);
            if (stack.m_41619_() || this.baritone.settings().itemSaver.get().booleanValue() && stack.m_41773_() >= stack.m_41776_() && stack.m_41776_() > 1 || !cla$$.isInstance(stack.m_41720_()) || !((speed = ToolSet.calculateSpeedVsBlock(stack, against.m_49966_())) > bestSpeed)) continue;
            bestSpeed = speed;
            bestInd = i;
        }
        return bestInd;
    }

    public boolean hasGenericThrowaway() {
        return this.throwaway(false, stack -> this.baritone.settings().acceptableThrowawayItems.get().contains(stack.m_41720_()));
    }

    public boolean selectThrowawayForLocation(boolean select, int x, int y, int z) {
        BlockState maybe = this.baritone.getBuilderProcess().placeAt(x, y, z, this.baritone.bsi.get0(x, y, z));
        if (maybe != null && this.throwaway(select, stack -> stack.m_41720_() instanceof BlockItem && maybe.equals(((BlockItem)stack.m_41720_()).m_40614_().m_5573_(new BlockPlaceContext(new UseOnContext((Level)this.ctx.world(), null, InteractionHand.MAIN_HAND, (ItemStack)stack, new BlockHitResult(new Vec3(this.ctx.entity().m_20185_(), this.ctx.entity().m_20186_(), this.ctx.entity().m_20189_()), Direction.UP, (BlockPos)this.ctx.feetPos(), false)){

            public boolean m_7078_() {
                return false;
            }
        }))))) {
            return true;
        }
        return maybe != null && this.throwaway(select, stack -> stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_().equals(maybe.m_60734_())) ? true : this.throwaway(select, stack -> this.baritone.settings().acceptableThrowawayItems.get().contains(stack.m_41720_()));
    }

    public boolean throwaway(boolean select, Predicate<? super ItemStack> desired) {
        ItemStack item;
        LivingEntity livingEntity = this.ctx.entity();
        if (!(livingEntity instanceof IInventoryProvider)) {
            return false;
        }
        IInventoryProvider p = (IInventoryProvider)livingEntity;
        NonNullList<ItemStack> var7 = p.getLivingInventory().main;
        for (int i = 0; i < 9; ++i) {
            item = (ItemStack)var7.get(i);
            if (!desired.test((ItemStack)item)) continue;
            if (select) {
                p.getLivingInventory().selectedSlot = i;
            }
            return true;
        }
        if (desired.test((ItemStack)((ItemStack)p.getLivingInventory().offHand.get(0)))) {
            for (int ix = 0; ix < 9; ++ix) {
                item = (ItemStack)var7.get(ix);
                if (!item.m_41619_() && !(item.m_41720_() instanceof PickaxeItem)) continue;
                if (select) {
                    p.getLivingInventory().selectedSlot = ix;
                }
                return true;
            }
        }
        return false;
    }

    public static int getSlotWithStack(LivingEntityInventory inv, TagKey<Item> tag) {
        for (int i = 0; i < inv.main.size(); ++i) {
            if (((ItemStack)inv.main.get(i)).m_41619_() || !((ItemStack)inv.main.get(i)).m_204117_(tag)) continue;
            return i;
        }
        return -1;
    }
}

