/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDownward;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementTraverse;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class MovementDescend
extends Movement {
    private int numTicks = 0;

    public MovementDescend(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, MovementDescend.buildPositionsToBreak(baritone.getEntityContext().entity(), start, end), end.down());
    }

    @NotNull
    private static BetterBlockPos[] buildPositionsToBreak(LivingEntity entity, BetterBlockPos start, BetterBlockPos end) {
        BetterBlockPos[] wall = MovementTraverse.buildPositionsToBreak((Entity)entity, start, end.up());
        BetterBlockPos[] floor = MovementDownward.buildPositionsToBreak((Entity)entity, end);
        return (BetterBlockPos[])ArrayUtils.addAll((Object[])wall, (Object[])floor);
    }

    @Override
    public void reset() {
        super.reset();
        this.numTicks = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.y != this.dest.y ? 1000000.0 : result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest.up()), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult res) {
        BlockState fromDown;
        BlockState destUp;
        double frontBreak = 0.0;
        BlockState destDown = context.get(destX, y - 1, destZ);
        res.x = destX;
        res.y = y - 1;
        res.z = destZ;
        if (!(destDown.m_60713_(Blocks.f_50616_) && ((Boolean)destDown.m_61143_((Property)ScaffoldingBlock.f_56014_)).booleanValue() || (frontBreak += MovementHelper.getMiningDurationTicks(context, destX, y - 1, destZ, destDown, false)) >= 1000000.0 || (destUp = context.get(destX, y, destZ)).m_60713_(Blocks.f_50616_) && ((Boolean)destUp.m_61143_((Property)ScaffoldingBlock.f_56014_)).booleanValue() || (frontBreak += MovementHelper.getMiningDurationTicks(context, destX, y, destZ, destUp, false)) >= 1000000.0 || (frontBreak += MovementHelper.getMiningDurationTicks(context, destX, y + 1, destZ, true)) >= 1000000.0 || (fromDown = context.get(x, y - 1, z)).m_204336_(BlockTags.f_13082_))) {
            BlockState below = context.get(destX, y - 2, destZ);
            if (!MovementHelper.canWalkOn(context.bsi, destX, y - 2, destZ, below, context.baritone.settings())) {
                MovementDescend.dynamicFallCost(context, x, y, z, destX, destZ, frontBreak, below, res);
                res.oxygenCost += context.oxygenCost(3.7062775075283763 + frontBreak, context.get(x, y + context.height - 1, z));
            } else if (destDown.m_60734_() != Blocks.f_50155_ && destDown.m_60734_() != Blocks.f_50191_) {
                double totalCost;
                boolean water = MovementHelper.isWater(destUp);
                double waterModifier = water ? context.waterWalkSpeed / 4.63284688441047 : 1.0;
                double walk = waterModifier * (3.7062775075283763 / (double)fromDown.m_60734_().m_49961_());
                double fall = waterModifier * Math.max(FALL_N_BLOCKS_COST[1], 0.9265693768820937);
                res.cost = totalCost = frontBreak + (walk + fall);
                res.oxygenCost = context.oxygenCost(walk / 2.0 + frontBreak, context.get(x, y + context.height - 1, z));
                res.oxygenCost += context.oxygenCost(fall / 2.0, context.get(destX, y + context.height - 2, destZ));
                res.oxygenCost += context.oxygenCost(walk / 2.0 + fall / 2.0, context.get(destX, y + context.height - 1, destZ));
            }
        }
    }

    public static boolean dynamicFallCost(CalculationContext context, int x, int y, int z, int destX, int destZ, double frontBreak, BlockState below, MutableMoveResult res) {
        if (frontBreak != 0.0 && context.get(destX, y + 2, destZ).m_60734_() instanceof FallingBlock) {
            return false;
        }
        if (!MovementHelper.canWalkThrough(context.bsi, destX, y - 2, destZ, below, context.baritone.settings())) {
            return false;
        }
        double costSoFar = 0.0;
        int effectiveStartHeight = y;
        int fallHeight = 3;
        int newY;
        while ((newY = y - fallHeight) >= context.worldBottom) {
            BlockState ontoBlock = context.get(destX, newY, destZ);
            int unprotectedFallHeight = fallHeight - (y - effectiveStartHeight);
            double fallCost = FALL_N_BLOCKS_COST[unprotectedFallHeight] + costSoFar;
            double tentativeCost = 3.7062775075283763 + fallCost + frontBreak;
            if (MovementHelper.isWater(ontoBlock)) {
                if (!MovementHelper.canWalkThrough(context.bsi, destX, newY, destZ, ontoBlock, context.baritone.settings())) {
                    return false;
                }
                if (context.assumeWalkOnWater) {
                    return false;
                }
                if (MovementHelper.isFlowing(destX, newY, destZ, ontoBlock, context.bsi)) {
                    return false;
                }
                if (!MovementHelper.canWalkOn(context.bsi, destX, newY - 1, destZ, context.baritone.settings())) {
                    return false;
                }
                res.x = destX;
                res.y = newY;
                res.z = destZ;
                res.cost = tentativeCost;
                res.oxygenCost = context.oxygenCost(fallCost, Blocks.f_50016_.m_49966_());
                return false;
            }
            if (unprotectedFallHeight > 11 || ontoBlock.m_60734_() != Blocks.f_50191_ && ontoBlock.m_60734_() != Blocks.f_50155_) {
                if (!MovementHelper.canWalkThrough(context.bsi, destX, newY, destZ, ontoBlock, context.baritone.settings())) {
                    if (!MovementHelper.canWalkOn(context.bsi, destX, newY, destZ, ontoBlock, context.baritone.settings())) {
                        return false;
                    }
                    if (MovementHelper.isBottomSlab(ontoBlock)) {
                        return false;
                    }
                    if (unprotectedFallHeight <= context.maxFallHeightNoWater + 1) {
                        res.x = destX;
                        res.y = newY + 1;
                        res.z = destZ;
                        res.cost = tentativeCost;
                        res.oxygenCost = context.oxygenCost(fallCost, Blocks.f_50016_.m_49966_());
                        return false;
                    }
                    if (context.hasWaterBucket && unprotectedFallHeight <= context.maxFallHeightBucket + 1) {
                        res.x = destX;
                        res.y = newY + 1;
                        res.z = destZ;
                        res.cost = tentativeCost + context.placeBucketCost();
                        res.oxygenCost = context.oxygenCost(fallCost, Blocks.f_50016_.m_49966_());
                        return true;
                    }
                    res.x = destX;
                    res.y = newY + 1;
                    res.z = destZ;
                    return false;
                }
            } else {
                costSoFar += FALL_N_BLOCKS_COST[unprotectedFallHeight - 1];
                costSoFar += 6.666666666666667;
                effectiveStartHeight = newY;
            }
            ++fallHeight;
        }
        return false;
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        BetterBlockPos playerFeet = this.ctx.feetPos();
        BlockPos fakeDest = new BlockPos(this.dest.m_123341_() * 2 - this.src.m_123341_(), this.dest.m_123342_(), this.dest.m_123343_() * 2 - this.src.m_123343_());
        if (!playerFeet.equals((Object)this.dest) && !playerFeet.equals(fakeDest) || !MovementHelper.isLiquid(this.ctx, this.dest) && !(this.ctx.entity().m_20186_() - (double)this.dest.m_123342_() < 0.5)) {
            double diffZ;
            double diffX = this.ctx.entity().m_20185_() - ((double)this.dest.m_123341_() + 0.5);
            double ab = Math.sqrt(diffX * diffX + (diffZ = this.ctx.entity().m_20189_() - ((double)this.dest.m_123343_() + 0.5)) * diffZ);
            if (ab < 0.2 && (this.ctx.world().m_8055_((BlockPos)this.dest).m_60713_(Blocks.f_50616_) || this.ctx.entity().m_5842_() && this.ctx.entity().m_20186_() > (double)this.src.y)) {
                state.setInput(Input.SNEAK, true);
            }
            if (this.safeMode()) {
                double destX = ((double)this.src.m_123341_() + 0.5) * 0.17 + ((double)this.dest.m_123341_() + 0.5) * 0.83;
                double destZ = ((double)this.src.m_123343_() + 0.5) * 0.17 + ((double)this.dest.m_123343_() + 0.5) * 0.83;
                LivingEntity player = this.ctx.entity();
                state.setTarget(new MovementState.MovementTarget(new Rotation(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), new Vec3(destX, (double)this.dest.m_123342_(), destZ), new Rotation(player.m_146908_(), player.m_146909_())).getYaw(), player.m_146909_()), false)).setInput(Input.MOVE_FORWARD, true);
                return state;
            }
            double x = this.ctx.entity().m_20185_() - ((double)this.src.m_123341_() + 0.5);
            double z = this.ctx.entity().m_20189_() - ((double)this.src.m_123343_() + 0.5);
            double fromStart = Math.sqrt(x * x + z * z);
            if (!playerFeet.equals((Object)this.dest) || ab > 0.25) {
                if (this.numTicks++ < 20 && fromStart < 1.25) {
                    MovementHelper.moveTowards(this.ctx, state, fakeDest);
                } else {
                    MovementHelper.moveTowards(this.ctx, state, this.dest);
                }
            }
            return state;
        }
        return state.setStatus(MovementStatus.SUCCESS);
    }

    public boolean safeMode() {
        BlockPos into = this.dest.m_121996_((Vec3i)this.src.down()).m_121955_((Vec3i)this.dest);
        if (this.skipToAscend()) {
            return true;
        }
        for (int y = 0; y <= 2; ++y) {
            BlockState state = BlockStateInterface.get(this.ctx, into.m_6630_(y));
            if (!MovementHelper.avoidWalkingInto(state) || MovementHelper.isWater(state) && this.baritone.settings().allowSwimming.get().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean skipToAscend() {
        BlockPos into = this.dest.m_121996_((Vec3i)this.src.down()).m_121955_((Vec3i)this.dest);
        return !MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into)) && MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into).up()) && MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into).up(2));
    }
}

