/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MovementPillar
extends Movement {
    public MovementPillar(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, MovementPillar.buildPositionsToBreak((Entity)baritone.getEntityContext().entity(), start), start);
    }

    public static BetterBlockPos[] buildPositionsToBreak(Entity entity, BetterBlockPos start) {
        int x = start.x;
        int y = start.y;
        int z = start.z;
        EntityDimensions dims = entity.m_6972_(Pose.STANDING);
        int requiredVerticalSpace = Mth.m_14167_((float)dims.f_20378_);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dims);
        int sideLength = requiredSideSpace * 2 + 1;
        BetterBlockPos[] ret = new BetterBlockPos[sideLength * sideLength];
        int i = 0;
        for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
            for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                ret[i++] = new BetterBlockPos(x + dx, y + requiredVerticalSpace, z + dz);
            }
        }
        return ret;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementPillar.cost(context, this.src.x, this.src.y, this.src.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
        BlockState fromState = context.get(x, y, z);
        boolean climbable = MovementPillar.isClimbable(context.bsi, x, y, z);
        BlockState fromDown = context.get(x, y - 1, z);
        if (!climbable) {
            if (fromDown.m_204336_(BlockTags.f_13082_)) {
                return;
            }
            if (fromDown.m_60734_() instanceof SlabBlock && fromDown.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
                return;
            }
        } else if (context.width > 1) {
            return;
        }
        double totalHardness = 0.0;
        boolean swimmable = false;
        int requiredSideSpace = context.requiredSideSpace;
        for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
            for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                double hardness;
                int checkedX = x + dx;
                int checkedY = y + context.height;
                int checkedZ = z + dz;
                BlockState toBreak = context.get(checkedX, checkedY, checkedZ);
                BlockState underToBreak = context.get(x, checkedY - 1, z);
                Block toBreakBlock = toBreak.m_60734_();
                if (toBreakBlock instanceof FenceGateBlock || !climbable && toBreakBlock instanceof ScaffoldingBlock) {
                    return;
                }
                boolean water = MovementHelper.isWater(toBreak);
                if (water || MovementHelper.isWater(underToBreak)) {
                    if (MovementHelper.isFlowing(checkedX, checkedY, checkedZ, toBreak, context.bsi)) {
                        return;
                    }
                    swimmable = true;
                    if (totalHardness > 0.0) {
                        return;
                    }
                }
                if (water || !((hardness = MovementHelper.getMiningDurationTicks(context, checkedX, checkedY, checkedZ, toBreak, true)) > 0.0)) continue;
                if (hardness >= 1000000.0 || swimmable) {
                    return;
                }
                BlockState check = context.get(checkedX, checkedY + 1, checkedZ);
                if (!(!(check.m_60734_() instanceof FallingBlock) || toBreakBlock instanceof FallingBlock && underToBreak.m_60734_() instanceof FallingBlock)) {
                    return;
                }
                totalHardness += hardness;
            }
        }
        if (!(!swimmable && MovementHelper.isLiquid(fromState) && !context.canPlaceAgainst(x, y - 1, z, fromDown) || MovementHelper.isLiquid(fromDown) && context.assumeWalkOnWater)) {
            double placeCost = 0.0;
            if (!climbable && !swimmable) {
                placeCost = context.costOfPlacingAt(x, y, z, fromState);
                if (placeCost >= 1000000.0) {
                    return;
                }
                if (fromDown.m_60795_()) {
                    placeCost += 0.1;
                }
            }
            if (!climbable && !swimmable) {
                result.cost = JUMP_ONE_BLOCK_COST + placeCost + context.jumpPenalty + totalHardness;
                result.oxygenCost = context.oxygenCost(JUMP_ONE_BLOCK_COST + placeCost + totalHardness, Blocks.f_50016_.m_49966_());
            } else {
                result.cost = 8.51063829787234 + totalHardness * 5.0;
                result.oxygenCost = context.oxygenCost(4.25531914893617 + totalHardness * 5.0, context.get(x, y + context.height - 1, z)) + context.oxygenCost(4.25531914893617, context.get(x, y + context.height, z));
            }
        }
    }

    private static boolean isClimbable(BlockStateInterface context, int x, int y, int z) {
        if (context.get0(x, y, z).m_204336_(BlockTags.f_13082_)) {
            return true;
        }
        return context.get0(x, y + 1, z).m_204336_(BlockTags.f_13082_) ? MovementHelper.isBlockNormalCube(context.get0(x, y - 1, z)) : false;
    }

    public static BlockPos getAgainst(CalculationContext context, BetterBlockPos vine) {
        if (MovementHelper.isBlockNormalCube(context.get(vine.north()))) {
            return vine.north();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.south()))) {
            return vine.south();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.east()))) {
            return vine.east();
        }
        return MovementHelper.isBlockNormalCube(context.get(vine.west())) ? vine.west() : null;
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.feetPos().y < this.src.y) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        BlockState fromDown = BlockStateInterface.get(this.ctx, this.src);
        if (!this.ctx.entity().m_20069_() && !MovementHelper.isWater(this.ctx, this.src.up(Mth.m_14167_((float)this.ctx.entity().m_20206_())))) {
            boolean blockIsThere;
            boolean ladder = MovementPillar.isClimbable(((Baritone)this.baritone).bsi, this.src.x, this.src.y, this.src.z);
            Rotation rotation = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(this.positionToPlace), new Rotation(this.ctx.entity().m_146908_(), this.ctx.entity().m_146909_()));
            if (!ladder) {
                state.setTarget(new MovementState.MovementTarget(new Rotation(this.ctx.entity().m_146908_(), rotation.getPitch()), true));
            }
            boolean bl = blockIsThere = MovementHelper.canWalkOn(this.ctx, this.src) || ladder;
            if (ladder) {
                if (this.ctx.entity().m_20205_() > 1.0f) {
                    this.baritone.logDirect("Large entities cannot climb ladders :/");
                    return state.setStatus(MovementStatus.UNREACHABLE);
                }
                BlockPos supportingBlock = MovementPillar.getSupportingBlock(this.baritone, this.ctx, this.src, fromDown);
                if (!(supportingBlock != null && this.ctx.feetPos().equals(supportingBlock.m_7494_()) || this.ctx.feetPos().equals((Object)this.dest))) {
                    if (supportingBlock != null) {
                        MovementHelper.moveTowards(this.ctx, state, supportingBlock);
                    } else {
                        MovementPillar.centerForAscend(this.ctx, this.dest, state, 0.27);
                    }
                    return state.setInput(Input.JUMP, true);
                }
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (!((Baritone)this.baritone).getInventoryBehavior().selectThrowawayForLocation(true, this.src.x, this.src.y, this.src.z)) {
                return state.setStatus(MovementStatus.UNREACHABLE);
            }
            state.setInput(Input.SNEAK, this.ctx.entity().m_20186_() > (double)this.dest.m_123342_() || this.ctx.entity().m_20186_() < (double)this.src.m_123342_() + 0.2);
            double diffX = this.ctx.entity().m_20185_() - ((double)this.dest.m_123341_() + 0.5);
            double diffZ = this.ctx.entity().m_20189_() - ((double)this.dest.m_123343_() + 0.5);
            double dist = Math.sqrt(diffX * diffX + diffZ * diffZ);
            double flatMotion = Math.sqrt(this.ctx.entity().m_20184_().f_82479_ * this.ctx.entity().m_20184_().f_82479_ + this.ctx.entity().m_20184_().f_82481_ * this.ctx.entity().m_20184_().f_82481_);
            if (dist > 0.17) {
                state.setInput(Input.MOVE_FORWARD, true);
                state.setTarget(new MovementState.MovementTarget(rotation, true));
            } else if (flatMotion < 0.05) {
                state.setInput(Input.JUMP, this.ctx.entity().m_20186_() < (double)this.dest.m_123342_());
            }
            if (!blockIsThere) {
                BlockState frState = BlockStateInterface.get(this.ctx, this.src);
                if (!frState.m_60795_() && !frState.m_247087_()) {
                    RotationUtils.reachable(this.ctx.entity(), (BlockPos)this.src, this.ctx.playerController().getBlockReachDistance()).map(rot -> new MovementState.MovementTarget((Rotation)rot, true)).ifPresent(state::setTarget);
                    state.setInput(Input.JUMP, false);
                    state.setInput(Input.CLICK_LEFT, true);
                    blockIsThere = false;
                } else if (this.ctx.entity().m_6144_() && (this.ctx.isLookingAt(this.src.down()) || this.ctx.isLookingAt(this.src)) && this.ctx.entity().m_20186_() > (double)this.dest.m_123342_() + 0.1) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
            }
            return this.ctx.feetPos().equals((Object)this.dest) && blockIsThere ? state.setStatus(MovementStatus.SUCCESS) : state;
        }
        MovementPillar.centerForAscend(this.ctx, this.dest, state, 0.2);
        state.setInput(Input.JUMP, true);
        return this.ctx.feetPos().equals((Object)this.dest) ? state.setStatus(MovementStatus.SUCCESS) : state;
    }

    @Nullable
    public static BlockPos getSupportingBlock(IBaritone baritone, IEntityContext ctx, BetterBlockPos src, BlockState climbableBlock) {
        Object supportingBlock = Block.m_49918_((VoxelShape)climbableBlock.m_60812_((BlockGetter)ctx.world(), (BlockPos)src), (Direction)Direction.UP) ? null : (climbableBlock.m_60734_() instanceof LadderBlock ? src.offset(((Direction)climbableBlock.m_61143_((Property)LadderBlock.f_54337_)).m_122424_()) : MovementPillar.getAgainst(new CalculationContext(baritone), src));
        return supportingBlock;
    }

    public static void centerForAscend(IEntityContext ctx, BetterBlockPos dest, MovementState state, double allowedDistance) {
        state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(ctx.headPos(), VecUtils.getBlockPosCenter(dest), ctx.entityRotations()), false));
        Vec3 destCenter = VecUtils.getBlockPosCenter(dest);
        if (Math.abs(ctx.entity().m_20185_() - destCenter.f_82479_) > allowedDistance || Math.abs(ctx.entity().m_20189_() - destCenter.f_82481_) > allowedDistance) {
            state.setInput(Input.MOVE_FORWARD, true);
        }
    }

    @Override
    protected boolean prepared(MovementState state) {
        Block block;
        if ((this.ctx.feetPos().equals((Object)this.src) || this.ctx.feetPos().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == Blocks.f_50155_ || block == Blocks.f_50191_)) {
            state.setInput(Input.SNEAK, true);
        }
        return super.prepared(state);
    }
}

