/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.path;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.pathing.calc.IPath;
import com.player2.playerengine.automaton.api.pathing.movement.IMovement;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.pathing.path.IPathExecutor;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.PathingBehavior;
import com.player2.playerengine.automaton.pathing.calc.AbstractNodeCostSearch;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementAscend;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDescend;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDiagonal;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementFall;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementTraverse;
import com.player2.playerengine.automaton.pathing.path.CutoffPath;
import com.player2.playerengine.automaton.pathing.path.SplicedPath;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PathExecutor
implements IPathExecutor {
    private static final double MAX_MAX_DIST_FROM_PATH = 3.0;
    private static final double MAX_DIST_FROM_PATH = 2.0;
    private static final double MAX_TICKS_AWAY = 200.0;
    private final IPath path;
    private int pathPosition;
    private int ticksAway;
    private int ticksOnCurrent;
    private Double currentMovementOriginalCostEstimate;
    private Integer costEstimateIndex;
    private boolean failed;
    private boolean recalcBP = true;
    private HashSet<BlockPos> toBreak = new HashSet();
    private HashSet<BlockPos> toPlace = new HashSet();
    private HashSet<BlockPos> toWalkInto = new HashSet();
    private final PathingBehavior behavior;
    private final IEntityContext ctx;
    private boolean sprintNextTick;

    public PathExecutor(PathingBehavior behavior, IPath path) {
        this.behavior = behavior;
        this.ctx = behavior.ctx;
        this.path = path;
        this.pathPosition = 0;
    }

    public void logDebug(String message) {
        this.ctx.logDebug(message);
    }

    public boolean onTick() {
        double currentCost;
        Tuple<Double, BlockPos> status;
        if (this.pathPosition == this.path.length() - 1) {
            ++this.pathPosition;
        }
        if (this.pathPosition >= this.path.length()) {
            return true;
        }
        Movement movement = (Movement)this.path.movements().get(this.pathPosition);
        BetterBlockPos whereAmI = this.ctx.feetPos();
        if (!movement.getValidPositions().contains((Object)whereAmI)) {
            for (int i = this.pathPosition + 3; i < this.path.length() - 1; ++i) {
                if (!((Movement)this.path.movements().get(i)).getValidPositions().contains((Object)whereAmI)) continue;
                if (i - this.pathPosition > 2) {
                    this.logDebug("Skipping forward " + (i - this.pathPosition) + " steps, to " + i);
                }
                this.pathPosition = i - 1;
                this.onChangeInPathPosition();
                this.onTick();
                return false;
            }
        }
        if (this.possiblyOffPath(status = this.closestPathPos(this.path), 2.0)) {
            ++this.ticksAway;
            PlayerEngine.LOGGER.warn("FAR AWAY FROM PATH FOR " + this.ticksAway + " TICKS. Current distance: " + String.valueOf(status.m_14418_()) + ". Threshold: 2.0");
            if ((double)this.ticksAway > 200.0) {
                this.logDebug("Too far away from path for too long, cancelling path");
                this.cancel();
                return false;
            }
        } else {
            this.ticksAway = 0;
        }
        if (this.possiblyOffPath(status, 3.0)) {
            this.logDebug("too far from path");
            this.cancel();
            return false;
        }
        BlockStateInterface bsi = new BlockStateInterface(this.ctx);
        for (int ix = this.pathPosition - 10; ix < this.pathPosition + 10; ++ix) {
            if (ix < 0 || ix >= this.path.movements().size()) continue;
            Movement m = (Movement)this.path.movements().get(ix);
            List<BlockPos> prevBreak = m.toBreak(bsi);
            List<BlockPos> prevPlace = m.toPlace(bsi);
            List<BlockPos> prevWalkInto = m.toWalkInto(bsi);
            m.resetBlockCache();
            if (!prevBreak.equals(m.toBreak(bsi))) {
                this.recalcBP = true;
            }
            if (!prevPlace.equals(m.toPlace(bsi))) {
                this.recalcBP = true;
            }
            if (prevWalkInto.equals(m.toWalkInto(bsi))) continue;
            this.recalcBP = true;
        }
        if (this.recalcBP) {
            HashSet<BlockPos> newBreak = new HashSet<BlockPos>();
            HashSet<BlockPos> newPlace = new HashSet<BlockPos>();
            HashSet<BlockPos> newWalkInto = new HashSet<BlockPos>();
            for (int ixx = this.pathPosition; ixx < this.path.movements().size(); ++ixx) {
                Movement mx = (Movement)this.path.movements().get(ixx);
                newBreak.addAll(mx.toBreak(bsi));
                newPlace.addAll(mx.toPlace(bsi));
                newWalkInto.addAll(mx.toWalkInto(bsi));
            }
            this.toBreak = newBreak;
            this.toPlace = newPlace;
            this.toWalkInto = newWalkInto;
            this.recalcBP = false;
        }
        Baritone baritone = this.behavior.baritone;
        if (this.pathPosition < this.path.movements().size() - 1) {
            IMovement next = this.path.movements().get(this.pathPosition + 1);
            if (!baritone.bsi.worldContainsLoadedChunk(next.getDest().x, next.getDest().z)) {
                this.logDebug("Pausing since destination is at edge of loaded chunks");
                this.clearKeys();
                return true;
            }
        }
        boolean canCancel = movement.safeToCancel();
        if (this.costEstimateIndex == null || this.costEstimateIndex != this.pathPosition) {
            this.costEstimateIndex = this.pathPosition;
            this.currentMovementOriginalCostEstimate = movement.getCost();
            for (int ixx = 1; ixx < baritone.settings().costVerificationLookahead.get() && this.pathPosition + ixx < this.path.length() - 1; ++ixx) {
                if (!(((Movement)this.path.movements().get(this.pathPosition + ixx)).calculateCost(this.behavior.secretInternalGetCalculationContext()) >= 1000000.0) || !canCancel) continue;
                this.logDebug("Something has changed in the world and a future movement has become impossible. Cancelling.");
                this.cancel();
                return true;
            }
        }
        if ((currentCost = movement.recalculateCost(this.behavior.secretInternalGetCalculationContext())) >= 1000000.0 && canCancel) {
            this.logDebug("Something has changed in the world and this movement has become impossible. Cancelling.");
            this.cancel();
            return true;
        }
        if (!movement.calculatedWhileLoaded() && currentCost - this.currentMovementOriginalCostEstimate > baritone.settings().maxCostIncrease.get() && canCancel) {
            this.logDebug("Original cost " + this.currentMovementOriginalCostEstimate + " current cost " + currentCost + ". Cancelling.");
            this.cancel();
            return true;
        }
        if (this.shouldPause()) {
            this.logDebug("Pausing since current best path is a backtrack");
            this.clearKeys();
            return true;
        }
        MovementStatus movementStatus = movement.update();
        if (movementStatus == MovementStatus.UNREACHABLE || movementStatus == MovementStatus.FAILED) {
            this.logDebug("Movement returns status " + String.valueOf((Object)movementStatus));
            this.cancel();
            return true;
        }
        if (movementStatus == MovementStatus.SUCCESS) {
            ++this.pathPosition;
            this.onChangeInPathPosition();
            this.onTick();
            return true;
        }
        this.ctx.entity().m_6858_(this.shouldSprintNextTick());
        ++this.ticksOnCurrent;
        if ((double)this.ticksOnCurrent > this.currentMovementOriginalCostEstimate + (double)baritone.settings().movementTimeoutTicks.get().intValue()) {
            this.logDebug("This movement has taken too long (" + this.ticksOnCurrent + " ticks, expected " + this.currentMovementOriginalCostEstimate + "). Cancelling.");
            this.cancel();
            return true;
        }
        return canCancel;
    }

    private Tuple<Double, BlockPos> closestPathPos(IPath path) {
        double best = -1.0;
        BlockPos bestPos = null;
        for (IMovement movement : path.movements()) {
            for (BlockPos blockPos : ((Movement)movement).getValidPositions()) {
                double dist = VecUtils.entityDistanceToCenter((Entity)this.ctx.entity(), blockPos);
                if (!(dist < best) && best != -1.0) continue;
                best = dist;
                bestPos = blockPos;
            }
        }
        return new Tuple((Object)best, bestPos);
    }

    private boolean shouldPause() {
        Optional<AbstractNodeCostSearch> current = this.behavior.getInProgress();
        if (!current.isPresent()) {
            return false;
        }
        if (!this.ctx.entity().m_20096_()) {
            return false;
        }
        if (!MovementHelper.canWalkOn(this.ctx, this.ctx.feetPos().down())) {
            return false;
        }
        if (!MovementHelper.canWalkThrough(this.ctx, this.ctx.feetPos()) || !MovementHelper.canWalkThrough(this.ctx, this.ctx.feetPos().up())) {
            return false;
        }
        if (!this.path.movements().get(this.pathPosition).safeToCancel()) {
            return false;
        }
        Optional<IPath> currentBest = current.get().bestPathSoFar();
        if (!currentBest.isPresent()) {
            return false;
        }
        List<BetterBlockPos> positions = currentBest.get().positions();
        if (positions.size() < 3) {
            return false;
        }
        positions = positions.subList(1, positions.size());
        return positions.contains((Object)this.ctx.feetPos());
    }

    private boolean possiblyOffPath(Tuple<Double, BlockPos> status, double leniency) {
        double distanceFromPath = (Double)status.m_14418_();
        if (distanceFromPath > leniency) {
            if (this.path.movements().get(this.pathPosition) instanceof MovementFall) {
                BlockPos fallDest = this.path.positions().get(this.pathPosition + 1);
                return VecUtils.entityFlatDistanceToCenter((Entity)this.ctx.entity(), fallDest) >= leniency;
            }
            return true;
        }
        return false;
    }

    public boolean snipsnapifpossible() {
        if (!this.ctx.entity().m_20096_() && this.ctx.world().m_6425_((BlockPos)this.ctx.feetPos()).m_76178_()) {
            return false;
        }
        if (this.ctx.entity().m_20184_().f_82480_ < -0.1) {
            return false;
        }
        int index = this.path.positions().indexOf((Object)this.ctx.feetPos());
        if (index == -1) {
            return false;
        }
        this.pathPosition = index;
        this.clearKeys();
        return true;
    }

    private boolean shouldSprintNextTick() {
        Tuple<Vec3, BlockPos> data;
        IMovement next;
        boolean requested = this.behavior.baritone.getInputOverrideHandler().isInputForcedDown(Input.SPRINT);
        this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.SPRINT, false);
        if (!new CalculationContext((IBaritone)this.behavior.baritone).canSprint) {
            return false;
        }
        IMovement current = this.path.movements().get(this.pathPosition);
        if (current instanceof MovementTraverse && this.pathPosition < this.path.length() - 3 && (next = this.path.movements().get(this.pathPosition + 1)) instanceof MovementAscend && this.behavior.baritone.settings().sprintAscends.get().booleanValue() && PathExecutor.sprintableAscend(this.ctx, (MovementTraverse)current, (MovementAscend)next, this.path.movements().get(this.pathPosition + 2))) {
            if (PathExecutor.skipNow(this.ctx, current)) {
                this.logDebug("Skipping traverse to straight ascend");
                ++this.pathPosition;
                this.onChangeInPathPosition();
                this.onTick();
                this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.JUMP, true);
                return true;
            }
            this.logDebug("Too far to the side to safely sprint ascend");
        }
        if (current instanceof MovementDiagonal && this.ctx.entity().m_5842_() && this.ctx.world().m_8055_((BlockPos)this.ctx.feetPos().up()).m_60819_().m_76178_()) {
            return false;
        }
        if (requested) {
            return true;
        }
        if (current instanceof MovementDescend) {
            if (((MovementDescend)current).safeMode() && !((MovementDescend)current).skipToAscend()) {
                this.logDebug("Sprinting would be unsafe");
                return false;
            }
            if (this.pathPosition < this.path.length() - 2) {
                next = this.path.movements().get(this.pathPosition + 1);
                if (next instanceof MovementAscend && current.getDirection().m_7494_().equals((Object)next.getDirection().m_7495_())) {
                    ++this.pathPosition;
                    this.onChangeInPathPosition();
                    this.onTick();
                    this.logDebug("Skipping descend to straight ascend");
                    return true;
                }
                if (PathExecutor.canSprintFromDescendInto(this.ctx, current, next, this.behavior.baritone.settings())) {
                    if (this.ctx.feetPos().equals((Object)current.getDest())) {
                        ++this.pathPosition;
                        this.onChangeInPathPosition();
                        this.onTick();
                    }
                    return true;
                }
            }
        }
        if (current instanceof MovementAscend && this.pathPosition != 0) {
            IMovement prev = this.path.movements().get(this.pathPosition - 1);
            if (prev instanceof MovementDescend && prev.getDirection().m_7494_().equals((Object)current.getDirection().m_7495_())) {
                BetterBlockPos center = current.getSrc().up();
                if (this.ctx.entity().m_20186_() >= (double)center.m_123342_() - 0.07) {
                    this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.JUMP, false);
                    return true;
                }
            }
            if (this.pathPosition < this.path.length() - 2 && prev instanceof MovementTraverse && PathExecutor.sprintableAscend(this.ctx, (MovementTraverse)prev, (MovementAscend)current, this.path.movements().get(this.pathPosition + 1))) {
                return true;
            }
            if (this.pathPosition < this.path.length() - 1 && (prev.getDirection().m_123341_() != 0 || prev.getDirection().m_123343_() != 0) && this.ctx.entity().m_5842_()) {
                return true;
            }
        }
        if (current instanceof MovementTraverse && this.ctx.entity().m_5842_() && this.pathPosition != 0) {
            IMovement prevx = this.path.movements().get(this.pathPosition - 1);
            return (prevx.getDirection().m_123341_() != 0 || prevx.getDirection().m_123343_() != 0) && !this.ctx.world().m_8055_((BlockPos)this.ctx.feetPos().up()).m_60819_().m_76178_();
        }
        if (current instanceof MovementFall && (data = this.overrideFall((MovementFall)current)) != null) {
            BetterBlockPos fallDest = new BetterBlockPos((BlockPos)data.m_14419_());
            if (!this.path.positions().contains((Object)fallDest)) {
                throw new IllegalStateException();
            }
            if (this.ctx.feetPos().equals((Object)fallDest)) {
                this.pathPosition = this.path.positions().indexOf((Object)fallDest);
                this.onChangeInPathPosition();
                this.onTick();
                return true;
            }
            this.clearKeys();
            this.behavior.baritone.getLookBehavior().updateTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), (Vec3)data.m_14418_(), this.ctx.entityRotations()), false);
            this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, true);
            return true;
        }
        return false;
    }

    private Tuple<Vec3, BlockPos> overrideFall(MovementFall movement) {
        IMovement next;
        int i;
        BlockPos dir = movement.getDirection();
        if (dir.m_123342_() < -3) {
            return null;
        }
        if (!movement.toBreakCached.isEmpty()) {
            return null;
        }
        Vec3i flatDir = new Vec3i(dir.m_123341_(), 0, dir.m_123343_());
        block0: for (i = this.pathPosition + 1; i < this.path.length() - 1 && i < this.pathPosition + 3 && (next = this.path.movements().get(i)) instanceof MovementTraverse && flatDir.equals((Object)next.getDirection()); ++i) {
            for (int y = next.getDest().y; y <= movement.getSrc().y + 1; ++y) {
                BlockPos chk = new BlockPos(next.getDest().x, y, next.getDest().z);
                if (!MovementHelper.fullyPassable(this.ctx, chk)) break block0;
            }
            if (!MovementHelper.canWalkOn(this.ctx, next.getDest().down())) break;
        }
        if (--i == this.pathPosition) {
            return null;
        }
        double len = (double)(i - this.pathPosition) - 0.4;
        return new Tuple((Object)new Vec3((double)flatDir.m_123341_() * len + (double)movement.getDest().x + 0.5, (double)movement.getDest().y, (double)flatDir.m_123343_() * len + (double)movement.getDest().z + 0.5), (Object)movement.getDest().m_7918_(flatDir.m_123341_() * (i - this.pathPosition), 0, flatDir.m_123343_() * (i - this.pathPosition)));
    }

    private static boolean skipNow(IEntityContext ctx, IMovement current) {
        double offTarget = Math.abs((double)current.getDirection().m_123341_() * ((double)current.getSrc().z + 0.5 - ctx.entity().m_20189_())) + Math.abs((double)current.getDirection().m_123343_() * ((double)current.getSrc().x + 0.5 - ctx.entity().m_20185_()));
        if (offTarget > 0.1) {
            return false;
        }
        BlockPos headBonk = current.getSrc().m_121996_((Vec3i)current.getDirection()).m_6630_(2);
        if (MovementHelper.fullyPassable(ctx, headBonk)) {
            return true;
        }
        double flatDist = Math.abs((double)current.getDirection().m_123341_() * ((double)headBonk.m_123341_() + 0.5 - ctx.entity().m_20185_())) + Math.abs((double)current.getDirection().m_123343_() * ((double)headBonk.m_123343_() + 0.5 - ctx.entity().m_20189_()));
        return flatDist > 0.8;
    }

    private static boolean sprintableAscend(IEntityContext ctx, MovementTraverse current, MovementAscend next, IMovement nextnext) {
        if (!current.getDirection().equals((Object)next.getDirection().m_7495_())) {
            return false;
        }
        if (nextnext.getDirection().m_123341_() == next.getDirection().m_123341_() && nextnext.getDirection().m_123343_() == next.getDirection().m_123343_()) {
            if (!MovementHelper.canWalkOn(ctx, current.getDest().down())) {
                return false;
            }
            if (!MovementHelper.canWalkOn(ctx, next.getDest().down())) {
                return false;
            }
            if (!next.toBreakCached.isEmpty()) {
                return false;
            }
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 3; ++y) {
                    BetterBlockPos chk = current.getSrc().up(y);
                    if (x == 1) {
                        chk = chk.m_121955_((Vec3i)current.getDirection());
                    }
                    if (MovementHelper.fullyPassable(ctx, chk)) continue;
                    return false;
                }
            }
            return MovementHelper.avoidWalkingInto(ctx.world().m_8055_((BlockPos)current.getSrc().up(3))) ? false : !MovementHelper.avoidWalkingInto(ctx.world().m_8055_((BlockPos)next.getDest().up(2)));
        }
        return false;
    }

    private static boolean canSprintFromDescendInto(IEntityContext ctx, IMovement current, IMovement next, Settings settings) {
        if (next instanceof MovementDescend && next.getDirection().equals((Object)current.getDirection())) {
            return true;
        }
        if (!MovementHelper.canWalkOn(ctx, current.getDest().m_121955_((Vec3i)current.getDirection()))) {
            return false;
        }
        return next instanceof MovementTraverse && next.getDirection().m_7495_().equals((Object)current.getDirection()) ? true : next instanceof MovementDiagonal && settings.allowOvershootDiagonalDescend.get() != false;
    }

    private void onChangeInPathPosition() {
        this.clearKeys();
        this.ticksOnCurrent = 0;
    }

    private void clearKeys() {
        this.behavior.baritone.getInputOverrideHandler().clearAllKeys();
    }

    private void cancel() {
        this.clearKeys();
        this.behavior.baritone.getInputOverrideHandler().getBlockBreakHelper().stopBreakingBlock();
        this.pathPosition = this.path.length() + 3;
        this.failed = true;
    }

    @Override
    public int getPosition() {
        return this.pathPosition;
    }

    public PathExecutor trySplice(PathExecutor next) {
        return next == null ? this.cutIfTooLong() : SplicedPath.trySplice(this.path, next.path, false).map(path -> {
            if (!path.getDest().equals((Object)next.getPath().getDest())) {
                throw new IllegalStateException();
            }
            PathExecutor ret = new PathExecutor(this.behavior, (IPath)path);
            ret.pathPosition = this.pathPosition;
            ret.currentMovementOriginalCostEstimate = this.currentMovementOriginalCostEstimate;
            ret.costEstimateIndex = this.costEstimateIndex;
            ret.ticksOnCurrent = this.ticksOnCurrent;
            return ret;
        }).orElseGet(this::cutIfTooLong);
    }

    private PathExecutor cutIfTooLong() {
        if (this.pathPosition > this.behavior.baritone.settings().maxPathHistoryLength.get()) {
            int cutoffAmt = this.behavior.baritone.settings().pathHistoryCutoffAmount.get();
            CutoffPath newPath = new CutoffPath(this.path, cutoffAmt, this.path.length() - 1);
            if (!newPath.getDest().equals((Object)this.path.getDest())) {
                throw new IllegalStateException();
            }
            this.logDebug("Discarding earliest segment movements, length cut from " + this.path.length() + " to " + newPath.length());
            PathExecutor ret = new PathExecutor(this.behavior, newPath);
            ret.pathPosition = this.pathPosition - cutoffAmt;
            ret.currentMovementOriginalCostEstimate = this.currentMovementOriginalCostEstimate;
            if (this.costEstimateIndex != null) {
                ret.costEstimateIndex = this.costEstimateIndex - cutoffAmt;
            }
            ret.ticksOnCurrent = this.ticksOnCurrent;
            return ret;
        }
        return this;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    public boolean failed() {
        return this.failed;
    }

    public boolean finished() {
        return this.pathPosition >= this.path.length();
    }

    public Set<BlockPos> toBreak() {
        return Collections.unmodifiableSet(this.toBreak);
    }

    public Set<BlockPos> toPlace() {
        return Collections.unmodifiableSet(this.toPlace);
    }

    public Set<BlockPos> toWalkInto() {
        return Collections.unmodifiableSet(this.toWalkInto);
    }

    public boolean isSprinting() {
        return this.sprintNextTick;
    }

    public static void writeToPacket(PathExecutor p, FriendlyByteBuf buf) {
        if (p == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(p.pathPosition);
            PathExecutor.writePositions(p.getPath().positions(), buf);
            PathExecutor.writePositions(p.toBreak(), buf);
            PathExecutor.writePositions(p.toPlace(), buf);
            PathExecutor.writePositions(p.toWalkInto(), buf);
        }
    }

    private static void writePositions(Collection<? extends BlockPos> positions, FriendlyByteBuf buf) {
        buf.m_130130_(positions.size());
        for (BlockPos blockPos : positions) {
            buf.m_130064_(blockPos);
        }
    }
}

