/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.path.PathExecutor;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;

public final class BackfillProcess
extends BaritoneProcessHelper {
    public HashMap<BlockPos, BlockState> blocksToReplace = new HashMap();

    public BackfillProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        if (this.ctx.entity() != null && this.ctx.world() != null) {
            if (!this.baritone.settings().backfill.get().booleanValue()) {
                return false;
            }
            if (this.baritone.settings().allowParkour.get().booleanValue()) {
                this.logDirect("Backfill cannot be used with allowParkour true");
                this.baritone.settings().backfill.set(false);
                return false;
            }
            this.amIBreakingABlockHMMMMMMM();
            for (BlockPos pos : new ArrayList<BlockPos>(this.blocksToReplace.keySet())) {
                if (!(this.ctx.world().m_46865_(pos) instanceof EmptyLevelChunk)) continue;
                this.blocksToReplace.remove(pos);
            }
            this.baritone.getInputOverrideHandler().clearAllKeys();
            return !this.toFillIn().isEmpty();
        }
        return false;
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        if (!isSafeToCancel) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        block5: for (BlockPos toPlace : this.toFillIn()) {
            MovementState fake = new MovementState();
            switch (MovementHelper.attemptToPlaceABlock(fake, this.baritone, toPlace, false, false)) {
                case NO_OPTION: {
                    continue block5;
                }
                case READY_TO_PLACE: {
                    this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
                    return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
                }
                case ATTEMPTING: {
                    this.baritone.getLookBehavior().updateTarget(fake.getTarget().getRotation().get(), true);
                    return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
                }
            }
            throw new IllegalStateException();
        }
        return new PathingCommand(null, PathingCommandType.DEFER);
    }

    private void amIBreakingABlockHMMMMMMM() {
        if (this.ctx.getSelectedBlock().isPresent()) {
            this.blocksToReplace.put(this.ctx.getSelectedBlock().get(), this.ctx.world().m_8055_(this.ctx.getSelectedBlock().get()));
        }
    }

    public List<BlockPos> toFillIn() {
        return this.blocksToReplace.keySet().stream().filter(pos -> this.ctx.world().m_8055_(pos).m_60734_() == Blocks.f_50016_).filter(pos -> this.baritone.getBuilderProcess().placementPlausible((BlockPos)pos, Blocks.f_50493_.m_49966_())).filter(pos -> !this.partOfCurrentMovement((BlockPos)pos)).sorted(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).m_123331_(arg_0)).reversed()).collect(Collectors.toList());
    }

    private boolean partOfCurrentMovement(BlockPos pos) {
        PathExecutor exec = this.baritone.getPathingBehavior().getCurrent();
        if (exec != null && !exec.finished() && !exec.failed()) {
            Movement movement = (Movement)exec.getPath().movements().get(exec.getPosition());
            return Arrays.asList(movement.toBreakAll()).contains(pos);
        }
        return false;
    }

    @Override
    public void onLostControl() {
        if (this.blocksToReplace != null && !this.blocksToReplace.isEmpty()) {
            this.blocksToReplace.clear();
        }
    }

    @Override
    public String displayName0() {
        return "Backfill";
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public double priority() {
        return 5.0;
    }
}

