/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForceEquipShieldArmorChain
extends SingleTaskChain {
    private ItemTarget[] toEquip = new ItemTarget[0];
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemTarget[][] ARMOR_BY_TIER_DESC = (ItemTarget[][])Arrays.stream(new Item[][]{ItemHelper.NETHERITE_ARMORS, ItemHelper.DIAMOND_ARMORS, ItemHelper.IRON_ARMORS, ItemHelper.CHAINMAIL_ARMORS, ItemHelper.GOLDEN_ARMORS, ItemHelper.LEATHER_ARMORS}).map(ItemTarget::of).toArray(x$0 -> new ItemTarget[x$0][]);

    private ItemTarget[] computeBetterArmorToEquip(PlayerEngineController controller) {
        int slots = ARMOR_BY_TIER_DESC[0].length;
        ArrayList<ItemTarget> upgrades = new ArrayList<ItemTarget>();
        for (int slot = 0; slot < slots; ++slot) {
            Optional<Object> ma = Optional.empty();
            for (int tier = 0; tier < ARMOR_BY_TIER_DESC.length; ++tier) {
                ItemTarget equippedCandidate = ARMOR_BY_TIER_DESC[tier][slot];
                if (!StorageHelper.isArmorEquipped(controller, equippedCandidate.getMatches()) && !controller.getItemStorage().hasItem(equippedCandidate.getMatches())) continue;
                ma = Optional.of(equippedCandidate);
                break;
            }
            if (!ma.isPresent() || StorageHelper.isArmorEquipped(controller, ((ItemTarget)ma.get()).getMatches())) continue;
            upgrades.add((ItemTarget)ma.get());
        }
        return upgrades.toArray(new ItemTarget[0]);
    }

    private boolean shouldEquipShield(PlayerEngineController controller) {
        return !StorageHelper.isItemInOffhand(controller, Items.f_42740_) && controller.getItemStorage().hasItem(ItemTarget.of(Items.f_42740_));
    }

    public ForceEquipShieldArmorChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    public float getPriority() {
        this.toEquip = this.computeBetterArmorToEquip(this.controller);
        if (this.toEquip.length > 0) {
            this.setTask(new EquipArmorTask(this.toEquip));
            return 100.0f;
        }
        if (this.shouldEquipShield(this.controller)) {
            this.controller.getSlotHandler().forceEquipItemToOffhand(Items.f_42740_);
        }
        return 0.0f;
    }

    @Override
    protected void onTaskFinish(PlayerEngineController controller) {
    }

    @Override
    public String getName() {
        return "ForceEquipShieldArmorChain";
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

