/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.tasks.movement.GoToStrongholdPortalTask;
import com.player2.playerengine.tasks.movement.LocateDesertTempleTask;

public class LocateStructureCommand
extends Command {
    public LocateStructureCommand() throws CommandException {
        super("locate_structure", "Locate a world generated structure. Only works for stronghold and desert_temple", new Arg<Structure>(Structure.class, "structure"));
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        Structure structure = parser.get(Structure.class);
        switch (structure.ordinal()) {
            case 1: {
                mod.runUserTask(new GoToStrongholdPortalTask(1), () -> this.finish());
                break;
            }
            case 0: {
                mod.runUserTask(new LocateDesertTempleTask(), () -> this.finish());
            }
        }
    }

    public static enum Structure {
        DESERT_TEMPLE,
        STRONGHOLD;

    }
}

