/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.manager;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.AgentConversationData;
import com.player2.playerengine.player2api.AgentSideEffects;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.Event;
import com.player2.playerengine.player2api.LLMCompleter;
import com.player2.playerengine.player2api.manager.TTSManager;
import com.player2.playerengine.player2api.status.StatusUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConversationManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static ConcurrentHashMap<UUID, AgentConversationData> queueData = new ConcurrentHashMap();
    public static final float messagePassingMaxDistance = 64.0f;
    private static boolean hasInit = false;
    private static List<LLMCompleter> llmCompleters = List.of(new LLMCompleter());

    public static void init() {
        if (!hasInit) {
            hasInit = true;
            ChatEvent.RECEIVED.register((player, component) -> {
                String message = component.m_6879_().getString();
                String sender = player.m_7755_().getString();
                ConversationManager.onUserChatMessage(new Event.UserMessage(message, sender));
                return EventResult.pass();
            });
        }
    }

    public static AgentConversationData getOrCreateEventQueueData(PlayerEngineController mod) {
        return queueData.computeIfAbsent(mod.getPlayer().m_20148_(), k -> {
            LOGGER.info("EventQueueManager/getOrCreateEventQueueData: creating new queue data for entId={}", (Object)mod.getPlayer().m_20149_());
            return new AgentConversationData(mod);
        });
    }

    private static Stream<AgentConversationData> filterQueueData(Predicate<AgentConversationData> pred) {
        return queueData.values().stream().filter(pred);
    }

    private static Stream<AgentConversationData> getCloseDataByUUID(UUID sender) {
        return ConversationManager.filterQueueData(data -> data.getDistance(sender) < 64.0f);
    }

    public static void onUserChatMessage(Event.UserMessage msg) {
        LOGGER.info("User message event={}", (Object)msg);
        ConversationManager.filterQueueData(d -> ConversationManager.isCloseToPlayer(d, msg.userName())).forEach(data -> data.onEvent(msg));
    }

    public static void onAICharacterMessage(Event.CharacterMessage msg, UUID senderId) {
        UUID sendingUUID = msg.sendingCharacterData().getUUID();
        ConversationManager.getCloseDataByUUID(sendingUUID).filter(data -> !data.getUUID().equals(senderId)).forEach(data -> {
            LOGGER.info("onCharMsg/ msg={}, sender={}, running onCharMsg for ={}", (Object)msg.message(), (Object)senderId, (Object)data.getName());
            data.onAICharacterMessage(msg);
        });
    }

    private static void process(Consumer<Event.CharacterMessage> onCharacterEvent, Consumer<String> onErrEvent) {
        Optional<AgentConversationData> dataToProcess = queueData.values().stream().filter(data -> data.getPriority() != 0L && data.getEntity() != null && data.getMod().getOwner() != null).max(Comparator.comparingLong(AgentConversationData::getPriority));
        llmCompleters.stream().filter(LLMCompleter::isAvailible).forEach(completer -> dataToProcess.ifPresent(data -> data.process(onCharacterEvent, onErrEvent, (LLMCompleter)completer)));
    }

    public static void injectOnTick(MinecraftServer server) {
        if (!hasInit) {
            ConversationManager.init();
        }
        Consumer<Event.CharacterMessage> onCharacterEvent = data -> AgentSideEffects.onEntityMessage(server, data);
        Consumer<String> onErrEvent = errMsg -> AgentSideEffects.onError(server, errMsg);
        if (!Lock.isConversationLocked()) {
            ConversationManager.process(onCharacterEvent, onErrEvent);
        }
        TTSManager.injectOnTick(server);
    }

    public static void sendGreeting(PlayerEngineController mod, Character character) {
        LOGGER.info("Sending greeting character={}", (Object)character);
        AgentConversationData data = ConversationManager.getOrCreateEventQueueData(mod);
        data.onGreeting();
    }

    public static void resetMemory(PlayerEngineController mod) {
        mod.getAIPersistantData().clearHistory();
    }

    private static boolean isCloseToPlayer(AgentConversationData data, String userName) {
        return StatusUtils.getDistanceToUsername(data.getMod(), userName) < 64.0f;
    }

    public void despwnCompanion(UUID id) {
        queueData.remove(id);
    }

    public static class Lock {
        public static boolean waitingForResponseLock = false;

        public static boolean isConversationLocked() {
            return waitingForResponseLock || TTSManager.isLocked();
        }
    }
}

