/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.Player2HTTPUtils;
import com.player2.playerengine.player2api.utils.Utils;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class CharacterUtils {
    public static Character DEFAULT_CHARACTER = new Character("AI agent", "AI", "Greetings", "You are a helpful AI Agent", "minecraft:textures/entity/player/wide/steve.png", new String[0]);

    public static Character parseFirstCharacter(Map<String, JsonElement> responseMap) {
        Character[] characters = CharacterUtils.parseCharacters(responseMap);
        return characters.length > 0 ? characters[0] : DEFAULT_CHARACTER;
    }

    public static Character[] parseCharacters(Map<String, JsonElement> responseMap) {
        try {
            if (!responseMap.containsKey("characters")) {
                throw new Exception("No characters found in API response.");
            }
            JsonArray charactersArray = responseMap.get("characters").getAsJsonArray();
            if (charactersArray.isEmpty()) {
                throw new Exception("Character list is empty.");
            }
            Character[] characters = new Character[charactersArray.size()];
            for (int i = 0; i < charactersArray.size(); ++i) {
                JsonObject firstCharacter = charactersArray.get(i).getAsJsonObject();
                String name = Utils.getStringJsonSafely(firstCharacter, "name");
                if (name == null) {
                    throw new Exception("Character is missing 'name'.");
                }
                String shortName = Utils.getStringJsonSafely(firstCharacter, "short_name");
                if (shortName == null) {
                    throw new Exception("Character is missing 'short_name'.");
                }
                String greeting = Utils.getStringJsonSafely(firstCharacter, "greeting");
                String description = Utils.getStringJsonSafely(firstCharacter, "description");
                String[] voiceIds = Utils.getStringArrayJsonSafely(firstCharacter, "voice_ids");
                JsonObject meta = firstCharacter.get("meta").getAsJsonObject();
                String skinURL = Utils.getStringJsonSafely(meta, "skin_url");
                characters[i] = new Character(name, shortName, greeting, description, skinURL, voiceIds);
            }
            return characters;
        }
        catch (Exception var12) {
            System.err.println("Warning, getSelectedCharacter failed, reverting to default. Error message: " + var12.getMessage());
            return new Character[0];
        }
    }

    public static Character[] requestCharacters(Player player, String player2GameId) {
        try {
            Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(player, player2GameId, "/v1/selected_characters", false, null);
            return CharacterUtils.parseCharacters(responseMap);
        }
        catch (Exception var2) {
            return new Character[0];
        }
    }

    public static Character requestFirstCharacter(Player player, String player2GameId) {
        try {
            Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(player, player2GameId, "/v1/selected_characters", false, null);
            return CharacterUtils.parseFirstCharacter(responseMap);
        }
        catch (Exception var2) {
            return DEFAULT_CHARACTER;
        }
    }

    public static Character readFromBuf(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        String shortName = buf.m_130277_();
        String greetingInfo = buf.m_130277_();
        String description = buf.m_130277_();
        String skinURL = buf.m_130277_();
        int arrSize = buf.readInt();
        String[] voiceIds = new String[arrSize];
        for (int i = 0; i < arrSize; ++i) {
            voiceIds[i] = buf.m_130277_();
        }
        return new Character(name, shortName, greetingInfo, description, skinURL, voiceIds);
    }

    public static void writeToBuf(FriendlyByteBuf buf, Character character) {
        buf.m_130070_(character.name());
        buf.m_130070_(character.shortName());
        buf.m_130070_(character.greetingInfo());
        buf.m_130070_(character.description());
        buf.m_130070_(character.skinURL());
        buf.writeInt(character.voiceIds().length);
        for (String id : character.voiceIds()) {
            buf.m_130070_(id);
        }
    }

    public static Character readFromNBT(CompoundTag compound) {
        String name = compound.m_128461_("name");
        String shortName = compound.m_128461_("shortName");
        String greetingInfo = compound.m_128461_("greetingInfo");
        String description = compound.m_128461_("description");
        String skinURL = compound.m_128461_("skinURL");
        ListTag voiceIdsList = compound.m_128437_("voiceIds", 8);
        String[] voiceIds = new String[voiceIdsList.size()];
        for (int i = 0; i < voiceIdsList.size(); ++i) {
            voiceIds[i] = voiceIdsList.m_128778_(i);
        }
        return new Character(name, shortName, greetingInfo, description, skinURL, voiceIds);
    }

    public static void writeToNBT(CompoundTag compound, Character character) {
        compound.m_128359_("name", character.name());
        compound.m_128359_("shortName", character.shortName());
        compound.m_128359_("greetingInfo", character.greetingInfo());
        compound.m_128359_("description", character.description());
        compound.m_128359_("skinURL", character.skinURL());
        ListTag voiceIds = new ListTag();
        for (String id : character.voiceIds()) {
            voiceIds.add((Object)StringTag.m_129297_((String)id));
        }
        compound.m_128365_("voiceIds", (Tag)voiceIds);
    }
}

