/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.ClearLiquidTask;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceObsidianBucketTask;
import com.player2.playerengine.tasks.movement.GetWithinRangeOfBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.speedrun.beatgame.BeatMinecraftTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ConstructNetherPortalBucketTask
extends Task {
    private static final Vec3i[] PORTAL_FRAME = new Vec3i[]{new Vec3i(0, 0, -1), new Vec3i(0, 1, -1), new Vec3i(0, 2, -1), new Vec3i(0, 0, 2), new Vec3i(0, 1, 2), new Vec3i(0, 2, 2), new Vec3i(0, 3, 0), new Vec3i(0, 3, 1), new Vec3i(0, -1, 0), new Vec3i(0, -1, 1)};
    private static final Vec3i[] PORTAL_INTERIOR = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(0, 1, 0), new Vec3i(0, 2, 0), new Vec3i(0, 0, 1), new Vec3i(0, 1, 1), new Vec3i(0, 2, 1), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0), new Vec3i(1, 2, 0), new Vec3i(1, 0, 1), new Vec3i(1, 1, 1), new Vec3i(1, 2, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(-1, 2, 0), new Vec3i(-1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(-1, 2, 1)};
    private static final Vec3i PORTALABLE_REGION_SIZE = new Vec3i(4, 6, 6);
    private static final Vec3i PORTAL_ORIGIN_RELATIVE_TO_REGION = new Vec3i(1, 0, 2);
    private final TimerGame lavaSearchTimer = new TimerGame(5.0);
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f);
    private final Task collectLavaTask = TaskCatalogue.getItemTask(Items.f_42448_, 1);
    private final TimerGame refreshTimer = new TimerGame(11.0);
    private BlockPos portalOrigin = null;
    private Task getToLakeTask = null;
    private BlockPos currentDestroyTarget = null;
    private boolean firstSearch = false;

    @Override
    protected void onStart() {
        this.currentDestroyTarget = null;
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(block -> {
            if (this.portalOrigin != null) {
                for (Vec3i framePosRelative : PORTAL_FRAME) {
                    BlockPos framePos = this.portalOrigin.m_121955_(framePosRelative);
                    if (!block.equals((Object)framePos)) continue;
                    return mod.getWorld().m_8055_(framePos).m_60734_() == Blocks.f_50080_;
                }
            }
            return false;
        });
        mod.getBehaviour().addProtectedItems(Items.f_42447_, Items.f_42448_, Items.f_42409_, Items.f_42613_);
        this.progressChecker.reset();
    }

    @Override
    protected Task onTick() {
        boolean needsToLookForPortal;
        PlayerEngineController mod = this.controller;
        if (this.portalOrigin != null && mod.getWorld().m_8055_(this.portalOrigin.m_7494_()).m_60734_() == Blocks.f_50142_) {
            this.setDebugState("Done constructing nether portal.");
            mod.getBlockScanner().addBlock(Blocks.f_50142_, this.portalOrigin.m_7494_());
            return null;
        }
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.setDebugState("Trying again.");
            this.progressChecker.reset();
            return this.wanderTask;
        }
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().forceCancel();
            if (this.portalOrigin != null && this.currentDestroyTarget != null) {
                mod.getBlockScanner().requestBlockUnreachable(this.portalOrigin);
                mod.getBlockScanner().requestBlockUnreachable(this.currentDestroyTarget);
                if (mod.getBlockScanner().isUnreachable(this.portalOrigin) && mod.getBlockScanner().isUnreachable(this.currentDestroyTarget)) {
                    this.portalOrigin = null;
                    this.currentDestroyTarget = null;
                }
                return this.wanderTask;
            }
        }
        if (this.refreshTimer.elapsed()) {
            Debug.logMessage("Duct tape: Refreshing inventory again just in case");
            this.refreshTimer.reset();
        }
        if (this.portalOrigin != null && !this.portalOrigin.m_203195_((Position)mod.getPlayer().m_20182_(), 2000.0)) {
            this.portalOrigin = null;
            this.currentDestroyTarget = null;
        }
        if (this.currentDestroyTarget != null) {
            if (WorldHelper.isSolidBlock(this.controller, this.currentDestroyTarget)) {
                return new DestroyBlockTask(this.currentDestroyTarget);
            }
            this.currentDestroyTarget = null;
        }
        if (!mod.getItemStorage().hasItem(Items.f_42409_) && !mod.getItemStorage().hasItem(Items.f_42613_)) {
            this.setDebugState("Getting flint & steel");
            this.progressChecker.reset();
            return TaskCatalogue.getItemTask(Items.f_42409_, 1);
        }
        int bucketCount = mod.getItemStorage().getItemCount(Items.f_42446_, Items.f_42448_, Items.f_42447_);
        if (bucketCount < 2) {
            this.setDebugState("Getting buckets");
            this.progressChecker.reset();
            if (mod.getItemStorage().hasItem(Items.f_42448_)) {
                return TaskCatalogue.getItemTask(Items.f_42447_, 1);
            }
            if (mod.getItemStorage().hasItem(Items.f_42447_)) {
                return TaskCatalogue.getItemTask(Items.f_42448_, 1);
            }
            return mod.getEntityTracker().itemDropped(Items.f_42447_, Items.f_42448_) ? new PickupDroppedItemTask(new ItemTarget(new Item[]{Items.f_42447_, Items.f_42448_}, 1), true) : TaskCatalogue.getItemTask(Items.f_42446_, 2);
        }
        boolean bl = needsToLookForPortal = this.portalOrigin == null;
        if (needsToLookForPortal) {
            this.progressChecker.reset();
            if (!mod.getItemStorage().hasItem(Items.f_42447_)) {
                this.setDebugState("Getting water");
                this.progressChecker.reset();
                return TaskCatalogue.getItemTask(Items.f_42447_, 1);
            }
            boolean foundSpot = false;
            if (this.firstSearch || this.lavaSearchTimer.elapsed()) {
                this.firstSearch = false;
                this.lavaSearchTimer.reset();
                Debug.logMessage("(Searching for lava lake with portalable spot nearby...)");
                BlockPos lavaPos = this.findLavaLake(mod, mod.getPlayer().m_20183_());
                if (lavaPos != null) {
                    BlockPos foundPortalRegion = this.getPortalableRegion(mod, lavaPos, mod.getPlayer().m_20183_(), new Vec3i(-1, 0, 0), PORTALABLE_REGION_SIZE, 20);
                    if (foundPortalRegion != null) {
                        this.portalOrigin = foundPortalRegion.m_121955_(PORTAL_ORIGIN_RELATIVE_TO_REGION);
                        foundSpot = true;
                        this.getToLakeTask = new GetWithinRangeOfBlockTask(this.portalOrigin, 7);
                        return this.getToLakeTask;
                    }
                    Debug.logWarning("Failed to find portalable region nearby. Consider increasing the search timeout range");
                } else {
                    Debug.logMessage("(lava lake not found)");
                }
            }
            if (!foundSpot) {
                this.setDebugState("(timeout: Looking for lava lake)");
                return new TimeoutWanderTask();
            }
        }
        if (BeatMinecraftTask.isTaskRunning(mod, this.getToLakeTask)) {
            return this.getToLakeTask;
        }
        for (Vec3i framePosRelative : PORTAL_FRAME) {
            BlockPos framePos = this.portalOrigin.m_121955_(framePosRelative);
            Block frameBlock = mod.getWorld().m_8055_(framePos).m_60734_();
            if (frameBlock != Blocks.f_50080_) {
                if (!mod.getItemStorage().hasItem(Items.f_42448_) && frameBlock != Blocks.f_49991_) {
                    this.setDebugState("Collecting lava");
                    this.progressChecker.reset();
                    return this.collectLavaTask;
                }
                if (mod.getBlockScanner().isUnreachable(framePos)) {
                    this.portalOrigin = null;
                }
                return new PlaceObsidianBucketTask(framePos);
            }
            BlockPos waterCheck = framePos.m_7494_();
            if (mod.getWorld().m_8055_(waterCheck).m_60734_() != Blocks.f_49990_ || !WorldHelper.isSourceBlock(this.controller, waterCheck, true)) continue;
            this.setDebugState("Clearing water from cast");
            return new ClearLiquidTask(waterCheck);
        }
        for (Vec3i offs : PORTAL_INTERIOR) {
            BlockPos p = this.portalOrigin.m_121955_(offs);
            assert (this.controller.getWorld() != null);
            if (this.controller.getWorld().m_8055_(p).m_60795_()) continue;
            this.setDebugState("Clearing inside of portal");
            this.currentDestroyTarget = p;
            return null;
        }
        this.setDebugState("Flinting and Steeling");
        return new InteractWithBlockTask(new ItemTarget(new Item[]{Items.f_42409_, Items.f_42613_}, 1), Direction.UP, this.portalOrigin.m_7495_(), true);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructNetherPortalBucketTask;
    }

    @Override
    protected String toDebugString() {
        return "Construct Nether Portal";
    }

    private BlockPos findLavaLake(PlayerEngineController mod, BlockPos playerPos) {
        HashSet<BlockPos> alreadyExplored = new HashSet<BlockPos>();
        double nearestSqDistance = Double.POSITIVE_INFINITY;
        BlockPos nearestLake = null;
        List<BlockPos> lavas = mod.getBlockScanner().getKnownLocations(Blocks.f_49991_);
        if (!lavas.isEmpty()) {
            for (BlockPos pos : lavas) {
                int depth;
                double sqDist;
                if (alreadyExplored.contains(pos) || !((sqDist = playerPos.m_123331_((Vec3i)pos)) < nearestSqDistance) || (depth = this.getNumberOfBlocksAdjacent(alreadyExplored, pos)) == 0) continue;
                Debug.logMessage("Found with depth " + depth);
                if (depth < 12) continue;
                nearestSqDistance = sqDist;
                nearestLake = pos;
            }
        }
        return nearestLake;
    }

    private int getNumberOfBlocksAdjacent(HashSet<BlockPos> alreadyExplored, BlockPos start) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        int bonus = 0;
        while (!queue.isEmpty()) {
            int level;
            BlockPos origin = (BlockPos)queue.poll();
            if (alreadyExplored.contains(origin)) continue;
            alreadyExplored.add(origin);
            assert (this.controller.getWorld() != null);
            BlockState s = this.controller.getWorld().m_8055_(origin);
            if (s.m_60734_() != Blocks.f_49991_ || !s.m_60819_().m_76170_() || (level = s.m_60819_().m_76186_()) != 8) continue;
            queue.addAll(List.of(origin.m_122012_(), origin.m_122019_(), origin.m_122029_(), origin.m_122024_(), origin.m_7494_(), origin.m_7495_()));
            ++bonus;
        }
        return bonus;
    }

    private BlockPos getPortalableRegion(PlayerEngineController mod, BlockPos lava, BlockPos playerPos, Vec3i sizeOffset, Vec3i sizeAllocation, int timeoutRange) {
        Vec3i[] directions = new Vec3i[]{new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1)};
        double minDistanceToPlayer = Double.POSITIVE_INFINITY;
        BlockPos bestPos = null;
        block0: for (Vec3i direction : directions) {
            for (int offs = 1; offs < timeoutRange; ++offs) {
                Vec3i offset = new Vec3i(direction.m_123341_() * offs, direction.m_123342_() * offs, direction.m_123343_() * offs);
                boolean found = true;
                boolean solidFound = false;
                block2: for (int dx = -1; dx < sizeAllocation.m_123341_() + 1; ++dx) {
                    for (int dz = -1; dz < sizeAllocation.m_123343_() + 1; ++dz) {
                        for (int dy = -1; dy < sizeAllocation.m_123342_(); ++dy) {
                            BlockPos toCheck = lava.m_121955_(offset).m_121955_(sizeOffset).m_7918_(dx, dy, dz);
                            assert (this.controller.getWorld() != null);
                            BlockState state = this.controller.getWorld().m_8055_(toCheck);
                            if (state.m_60734_() == Blocks.f_49991_ || state.m_60734_() == Blocks.f_49990_ || state.m_60734_() == Blocks.f_50752_) {
                                found = false;
                                break block2;
                            }
                            if (dy > 1 || solidFound || !WorldHelper.isSolidBlock(this.controller, toCheck)) continue;
                            solidFound = true;
                        }
                    }
                }
                if (!solidFound) continue block0;
                if (!found) continue;
                BlockPos foundBoxCorner = lava.m_121955_(offset).m_121955_(sizeOffset);
                double sqDistance = foundBoxCorner.m_123331_((Vec3i)playerPos);
                if (!(sqDistance < minDistanceToPlayer)) continue block0;
                minDistanceToPlayer = sqDistance;
                bestPos = foundBoxCorner;
                continue block0;
            }
        }
        return bestPos;
    }
}

