/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.misc.LootDesertTempleTask;
import com.player2.playerengine.tasks.movement.SearchWithinBiomeTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class RavageDesertTemplesTask
extends Task {
    public final Item[] LOOT = new Item[]{Items.f_42500_, Items.f_42583_, Items.f_42403_, Items.f_41830_, Items.f_42401_, Items.f_42591_, Items.f_42690_, Items.f_42450_, Items.f_42436_, Items.f_42417_, Items.f_42416_, Items.f_42616_, Items.f_42651_, Items.f_42652_, Items.f_42415_, Items.f_42653_, Items.f_42437_};
    private BlockPos currentTemple;
    private Task lootTask;
    private Task pickaxeTask;

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
    }

    @Override
    protected Task onTick() {
        if (this.pickaxeTask != null && !this.pickaxeTask.isFinished()) {
            this.setDebugState("Need to get pickaxes first");
            return this.pickaxeTask;
        }
        if (this.lootTask != null && !this.lootTask.isFinished()) {
            this.setDebugState("Looting found temple");
            return this.lootTask;
        }
        if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.WOOD)) {
            this.setDebugState("Need to get pickaxes first");
            this.pickaxeTask = new CataloguedResourceTask(new ItemTarget(Items.f_42422_, 2));
            return this.pickaxeTask;
        }
        this.currentTemple = WorldHelper.getADesertTemple(this.controller);
        if (this.currentTemple != null) {
            this.lootTask = new LootDesertTempleTask(this.currentTemple, List.of(this.LOOT));
            this.setDebugState("Looting found temple");
            return this.lootTask;
        }
        return new SearchWithinBiomeTask((ResourceKey<Biome>)Biomes.f_48203_);
    }

    @Override
    protected void onStop(Task task) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof RavageDesertTemplesTask;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Ravaging Desert Temples";
    }
}

