/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalObsidianTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.EnterNetherPortalTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.NotImplementedException;

public class FastTravelTask
extends Task {
    private static final double IN_NETHER_CLOSE_ENOUGH_THRESHOLD = 15.0;
    private final boolean collectPortalMaterialsIfAbsent;
    private final BlockPos target;
    private final Integer threshold;
    private final TimerGame attemptToMoveToIdealNetherCoordinateTimeout = new TimerGame(15.0);
    private boolean forceOverworldWalking;
    private Task goToOverworldTask;

    public FastTravelTask(BlockPos overworldTarget, Integer threshold, boolean collectPortalMaterialsIfAbsent) {
        this.target = overworldTarget;
        this.threshold = null;
        this.collectPortalMaterialsIfAbsent = collectPortalMaterialsIfAbsent;
    }

    public FastTravelTask(BlockPos overworldTarget, boolean collectPortalMaterialsIfAbsent) {
        this(overworldTarget, null, collectPortalMaterialsIfAbsent);
    }

    @Override
    protected void onStart() {
        BlockPos netherTarget = new BlockPos(this.target.m_123341_() / 8, this.target.m_123342_(), this.target.m_123343_() / 8);
        this.goToOverworldTask = new EnterNetherPortalTask(new ConstructNetherPortalObsidianTask(), Dimension.OVERWORLD, checkPos -> WorldHelper.inRangeXZ(checkPos, netherTarget, 7.0));
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        BlockPos netherTarget = new BlockPos(this.target.m_123341_() / 8, this.target.m_123342_(), this.target.m_123343_() / 8);
        boolean canBuildPortal = mod.getItemStorage().hasItem(Items.f_42390_) || mod.getItemStorage().getItemCount(Items.f_41999_) >= 10;
        boolean canLightPortal = mod.getItemStorage().hasItem(Items.f_42409_, Items.f_42613_);
        switch (WorldHelper.getCurrentDimension(this.controller)) {
            case OVERWORLD: {
                this.attemptToMoveToIdealNetherCoordinateTimeout.reset();
                if (!this.forceOverworldWalking && !WorldHelper.inRangeXZ((Entity)mod.getPlayer(), this.target, (double)this.getOverworldThreshold(mod))) {
                    if (!canBuildPortal || !canLightPortal) {
                        if (!this.collectPortalMaterialsIfAbsent) {
                            this.setDebugState("Walking: We don't have portal building materials");
                            return new GetToBlockTask(this.target);
                        }
                        this.setDebugState("Collecting portal building materials");
                        if (!canBuildPortal) {
                            return TaskCatalogue.getItemTask(Items.f_42390_, 1);
                        }
                        if (!canLightPortal) {
                            return TaskCatalogue.getItemTask(Items.f_42409_, 1);
                        }
                    }
                    return new DefaultGoToDimensionTask(Dimension.NETHER);
                }
                this.forceOverworldWalking = true;
                this.setDebugState("Walking: We're close enough to our target");
                if (mod.getBlockScanner().anyFound(Blocks.f_50258_)) {
                    this.setDebugState("Walking to portal");
                    return new GetToBlockTask(mod.getBlockScanner().getNearestBlock(Blocks.f_50258_).get());
                }
                return new GetToBlockTask(this.target);
            }
            case NETHER: {
                Optional<BlockPos> portalEntrance;
                if (!this.forceOverworldWalking && (portalEntrance = mod.getMiscBlockTracker().getLastUsedNetherPortal(Dimension.NETHER)).isPresent() && !portalEntrance.get().m_123314_(new Vec3i((int)mod.getPlayer().m_20182_().f_82479_, (int)mod.getPlayer().m_20182_().f_82480_, (int)mod.getPlayer().m_20182_().f_82481_), 3.0)) {
                    this.forceOverworldWalking = true;
                }
                if (this.goToOverworldTask.isActive() && !this.goToOverworldTask.isFinished()) {
                    this.setDebugState("Going back to overworld");
                    return this.goToOverworldTask;
                }
                if (mod.getItemStorage().getItemCount(Items.f_41999_) < 10) {
                    this.setDebugState("Making sure we can build our portal");
                    return TaskCatalogue.getItemTask(Items.f_41999_, 10);
                }
                if (!canLightPortal && mod.getEntityTracker().itemDropped(Items.f_42409_, Items.f_42613_)) {
                    this.setDebugState("Making sure we can light our portal");
                    return new PickupDroppedItemTask(new ItemTarget(Items.f_42409_, Items.f_42613_), true);
                }
                if (!(WorldHelper.inRangeXZ((Entity)mod.getPlayer(), netherTarget, 15.0) && mod.getBaritone().getPathingBehavior().isSafeToCancel() && (mod.getPlayer().m_146903_() == netherTarget.m_123341_() && mod.getPlayer().m_146907_() == netherTarget.m_123343_() || this.attemptToMoveToIdealNetherCoordinateTimeout.elapsed()))) {
                    this.attemptToMoveToIdealNetherCoordinateTimeout.reset();
                    this.setDebugState("Traveling to ideal coordinates");
                    return new GetToXZTask(netherTarget.m_123341_(), netherTarget.m_123343_());
                }
                return this.goToOverworldTask;
            }
            case END: {
                this.setDebugState("Why are you running this here?");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
        }
        throw new NotImplementedException("Unimplemented dimension: " + String.valueOf((Object)WorldHelper.getCurrentDimension(this.controller)));
    }

    private int getOverworldThreshold(PlayerEngineController mod) {
        int threshold = this.threshold == null ? mod.getModSettings().getNetherFastTravelWalkingRange() : this.threshold.intValue();
        threshold = Math.max(152, threshold);
        return Math.max(128, threshold);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof FastTravelTask)) {
            bl = false;
        } else {
            FastTravelTask task = (FastTravelTask)other;
            bl = task.target.equals((Object)this.target) && task.collectPortalMaterialsIfAbsent == this.collectPortalMaterialsIfAbsent && Objects.equals(task.threshold, this.threshold);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Fast travelling to " + this.target.m_123344_();
    }
}

