/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;

public class GetOutOfWaterTask
extends CustomBaritoneGoalTask {
    private boolean startedShimmying = false;
    private final TimerGame shimmyTaskTimer = new TimerGame(5.0);

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getPlayer().m_20146_() >= mod.getPlayer().m_6062_() && !mod.getPlayer().m_5842_()) {
            boolean hasBlockBelow = false;
            for (int i = 0; i < 3; ++i) {
                if (mod.getWorld().m_8055_(mod.getPlayer().m_20097_().m_6625_(i)).m_60734_() == Blocks.f_49990_) continue;
                hasBlockBelow = true;
            }
            boolean hasAirAbove = mod.getWorld().m_8055_(mod.getPlayer().m_20183_().m_6630_(2)).m_60734_().equals(Blocks.f_50016_);
            if (hasAirAbove && hasBlockBelow && StorageHelper.getNumberOfThrowawayBlocks(mod) > 0) {
                mod.getInputControls().tryPress(Input.JUMP);
                if (mod.getPlayer().m_20096_()) {
                    if (!this.startedShimmying) {
                        this.startedShimmying = true;
                        this.shimmyTaskTimer.reset();
                    }
                    return new SafeRandomShimmyTask();
                }
                mod.getSlotHandler().forceEquipItem(mod.getBaritoneSettings().acceptableThrowawayItems.get().toArray(new Item[0]));
                LookHelper.lookAt(mod, mod.getPlayer().m_20097_().m_7495_());
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
            }
            return super.onTick();
        }
        return super.onTick();
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new EscapeFromWaterGoal(mod);
    }

    @Override
    protected boolean isEqual(Task other) {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "";
    }

    @Override
    public boolean isFinished() {
        return !this.controller.getPlayer().m_20069_() && this.controller.getPlayer().m_20096_();
    }

    private class EscapeFromWaterGoal
    implements Goal {
        private PlayerEngineController mod;

        private EscapeFromWaterGoal(PlayerEngineController mod) {
            this.mod = mod;
        }

        private boolean isWater(int x, int y, int z) {
            return this.mod.getWorld() == null ? false : MovementHelper.isWater(this.mod.getWorld().m_8055_(new BlockPos(x, y, z)));
        }

        private boolean isWaterAdjacent(int x, int y, int z) {
            return this.isWater(x + 1, y, z) || this.isWater(x - 1, y, z) || this.isWater(x, y, z + 1) || this.isWater(x, y, z - 1) || this.isWater(x + 1, y, z - 1) || this.isWater(x + 1, y, z + 1) || this.isWater(x - 1, y, z - 1) || this.isWater(x - 1, y, z + 1);
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return !this.isWater(x, y, z) && !this.isWaterAdjacent(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            if (this.isWater(x, y, z)) {
                return 1.0;
            }
            return this.isWaterAdjacent(x, y, z) ? 0.5 : 0.0;
        }
    }
}

