/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.phys.Vec3;

public class TimeoutWanderTask
extends Task
implements ITaskRequiresGrounded {
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final float distanceToWander;
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final boolean increaseRange;
    private final TimerGame timer = new TimerGame(60.0);
    Block[] annoyingBlocks = new Block[]{Blocks.f_50191_, Blocks.f_50694_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50703_, Blocks.f_50155_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_50359_, Blocks.f_50034_, Blocks.f_50685_};
    private Vec3 origin;
    private boolean forceExplore;
    private Task unstuckTask = null;
    private int failCounter;
    private double wanderDistanceExtension;

    public TimeoutWanderTask(float distanceToWander, boolean increaseRange) {
        this.distanceToWander = distanceToWander;
        this.increaseRange = increaseRange;
        this.forceExplore = false;
    }

    public TimeoutWanderTask(float distanceToWander) {
        this(distanceToWander, false);
    }

    public TimeoutWanderTask() {
        this(Float.POSITIVE_INFINITY, false);
    }

    public TimeoutWanderTask(boolean forceExplore) {
        this();
        this.forceExplore = forceExplore;
    }

    private static BlockPos[] generateSides(BlockPos pos) {
        return new BlockPos[]{pos.m_7918_(1, 0, 0), pos.m_7918_(-1, 0, 0), pos.m_7918_(0, 0, 1), pos.m_7918_(0, 0, -1), pos.m_7918_(1, 0, -1), pos.m_7918_(1, 0, 1), pos.m_7918_(-1, 0, -1), pos.m_7918_(-1, 0, 1)};
    }

    private boolean isAnnoying(PlayerEngineController mod, BlockPos pos) {
        int b = 0;
        Block[] arrayOfBlock = this.annoyingBlocks;
        int i = arrayOfBlock.length;
        if (b >= i) {
            return false;
        }
        Block AnnoyingBlocks = arrayOfBlock[b];
        return mod.getWorld().m_8055_(pos).m_60734_() == AnnoyingBlocks || mod.getWorld().m_8055_(pos).m_60734_() instanceof DoorBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FenceBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FenceGateBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FlowerBlock;
    }

    public void resetWander() {
        this.wanderDistanceExtension = 0.0;
    }

    private BlockPos stuckInBlock(PlayerEngineController mod) {
        BlockPos[] toCheckHigh;
        BlockPos[] toCheck;
        BlockPos p = mod.getPlayer().m_20183_();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.m_7494_())) {
            return p.m_7494_();
        }
        for (BlockPos check : toCheck = TimeoutWanderTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (BlockPos checkx : toCheckHigh = TimeoutWanderTask.generateSides(p.m_7494_())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        this.timer.reset();
        mod.getBaritone().getPathingBehavior().forceCancel();
        this.origin = mod.getPlayer().m_20182_();
        this.progressChecker.reset();
        this.stuckCheck.reset();
        this.failCounter = 0;
        ItemStack cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
        if (!cursorStack.m_41619_()) {
            Optional<Slot> moveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursorStack, false);
            moveTo.ifPresent(slot -> mod.getSlotHandler().clickSlot((Slot)slot, 0, ClickType.PICKUP));
            if (ItemHelper.canThrowAwayStack(mod, cursorStack)) {
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            garbage.ifPresent(slot -> mod.getSlotHandler().clickSlot((Slot)slot, 0, ClickType.PICKUP));
            mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
        }
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                mod.getInputControls().hold(Input.SNEAK);
                mod.getInputControls().hold(Input.MOVE_FORWARD);
                return null;
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.progressChecker.check(mod) || !this.stuckCheck.check(mod)) {
            for (Entity CloseEntities : mod.getEntityTracker().getCloseEntities()) {
                if (!(CloseEntities instanceof Mob) || !CloseEntities.m_20182_().m_82509_((Position)mod.getPlayer().m_20182_(), 1.0) || CloseEntities == mod.getEntity()) continue;
                this.setDebugState("Killing annoying entity.");
                return new KillEntitiesTask(CloseEntities.getClass());
            }
            BlockPos blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                ++this.failCounter;
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        this.setDebugState("Exploring.");
        switch (WorldHelper.getCurrentDimension(this.controller)) {
            case END: {
                if (!(this.timer.getDuration() >= 30.0)) break;
                this.timer.reset();
                break;
            }
            case OVERWORLD: 
            case NETHER: {
                if (this.timer.getDuration() >= 30.0) {
                    // empty if block
                }
                if (!this.timer.elapsed()) break;
                this.timer.reset();
            }
        }
        if (!mod.getBaritone().getExploreProcess().isActive()) {
            mod.getBaritone().getExploreProcess().explore((int)this.origin.m_7096_(), (int)this.origin.m_7094_());
        }
        if (!this.progressChecker.check(mod)) {
            this.progressChecker.reset();
            if (!this.forceExplore) {
                ++this.failCounter;
                Debug.logMessage("Failed exploring.");
                if (this.progressChecker.lastBreakingBlock != null) {
                    // empty if block
                }
            }
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        if (this.isFinished() && this.increaseRange) {
            this.wanderDistanceExtension += (double)this.distanceToWander;
            Debug.logMessage("Increased wander range");
        }
    }

    @Override
    public boolean isFinished() {
        if (Float.isInfinite(this.distanceToWander)) {
            return false;
        }
        if (this.failCounter > 10) {
            return true;
        }
        LivingEntity player = this.controller.getPlayer();
        if (player != null && player.m_20182_() != null && (player.m_20096_() || player.m_20069_())) {
            double toWander;
            double sqDist = player.m_20182_().m_82557_(this.origin);
            return sqDist > (toWander = (double)this.distanceToWander + this.wanderDistanceExtension) * toWander;
        }
        return false;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof TimeoutWanderTask) {
            TimeoutWanderTask task = (TimeoutWanderTask)other;
            return !Float.isInfinite(task.distanceToWander) && !Float.isInfinite(this.distanceToWander) ? Math.abs(task.distanceToWander - this.distanceToWander) < 0.5f : Float.isInfinite(task.distanceToWander) == Float.isInfinite(this.distanceToWander);
        }
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Wander for " + this.distanceToWander + this.wanderDistanceExtension + " blocks";
    }
}

