/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectCoarseDirtTask
extends ResourceTask {
    private static final float CLOSE_ENOUGH_COARSE_DIRT = 128.0f;
    private final int count;

    public CollectCoarseDirtTask(int targetCount) {
        super(Items.f_42382_, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        block5: {
            Optional<BlockPos> closest;
            block4: {
                double c = Math.ceil((double)(this.count - mod.getItemStorage().getItemCount(Items.f_42382_)) / 4.0) * 2.0;
                closest = mod.getBlockScanner().getNearestBlock(Blocks.f_50546_);
                if ((double)mod.getItemStorage().getItemCount(Items.f_42329_) < c) break block4;
                Item[] itemArray = new Item[]{Items.f_41832_};
                if (!((double)mod.getItemStorage().getItemCount(itemArray) < c)) break block5;
            }
            if (closest.isPresent() && closest.get().m_203195_((Position)mod.getPlayer().m_20182_(), 128.0)) {
                return new MineAndCollectTask(new ItemTarget(Items.f_42382_), new Block[]{Blocks.f_50546_}, MiningRequirement.HAND).forceDimension(Dimension.OVERWORLD);
            }
        }
        int target = this.count;
        ItemTarget d = new ItemTarget(Items.f_42329_, 1);
        ItemTarget g = new ItemTarget(Items.f_41832_, 1);
        return new CraftInInventoryTask(new RecipeTarget(Items.f_42382_, target, CraftingRecipe.newShapedRecipe("coarse_dirt", new ItemTarget[]{d, g, g, d}, 4)));
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectCoarseDirtTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Coarse Dirt.";
    }
}

