/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectWheatTask
extends ResourceTask {
    private final int count;

    public CollectWheatTask(int targetCount) {
        super(Items.f_42405_, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        int potentialCount = mod.getItemStorage().getItemCount(Items.f_42405_) + 9 * mod.getItemStorage().getItemCount(Items.f_42129_);
        if (potentialCount >= this.count) {
            this.setDebugState("Crafting wheat");
            return new CraftInInventoryTask(new RecipeTarget(Items.f_42405_, this.count, CraftingRecipe.newShapedRecipe("wheat", new ItemTarget[]{new ItemTarget(Items.f_42129_, 1), null, null, null}, 9)));
        }
        return !mod.getBlockScanner().anyFound(Blocks.f_50335_) && !mod.getEntityTracker().itemDropped(Items.f_42129_) ? new CollectCropTask(new ItemTarget(Items.f_42405_, this.count), new Block[]{Blocks.f_50092_}, Items.f_42404_) : new MineAndCollectTask(Items.f_42129_, 99999999, new Block[]{Blocks.f_50335_}, MiningRequirement.HAND);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectWheatTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " wheat.";
    }
}

