/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.eventbus.EventBus;
import com.player2.playerengine.eventbus.events.PlayerCollidedWithEntityEvent;
import com.player2.playerengine.mixins.PersistentProjectileEntityAccessor;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.trackers.blacklisting.EntityLocateBlacklist;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.baritone.CachedProjectile;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class EntityTracker
extends Tracker {
    private final HashMap<Item, List<ItemEntity>> itemDropLocations = new HashMap();
    private final HashMap<Class, List<Entity>> entityMap = new HashMap();
    private final List<Entity> closeEntities = new ArrayList<Entity>();
    private final List<LivingEntity> hostiles = new ArrayList<LivingEntity>();
    private final List<CachedProjectile> projectiles = new ArrayList<CachedProjectile>();
    private final HashMap<String, Player> playerMap = new HashMap();
    private final HashMap<String, Vec3> playerLastCoordinates = new HashMap();
    private final EntityLocateBlacklist entityBlacklist = new EntityLocateBlacklist();
    private final HashMap<LivingEntity, List<Entity>> entitiesCollidingWithPlayerAccumulator = new HashMap();
    private final HashMap<LivingEntity, HashSet<Entity>> entitiesCollidingWithPlayer = new HashMap();

    public EntityTracker(TrackerManager manager) {
        super(manager);
        EventBus.subscribe(PlayerCollidedWithEntityEvent.class, evt -> this.registerPlayerCollision((LivingEntity)evt.player, evt.other));
    }

    private static Class squashType(Class<?> type) {
        return Player.class.isAssignableFrom(type) ? Player.class : type;
    }

    private void registerPlayerCollision(LivingEntity player, Entity entity) {
        if (!this.entitiesCollidingWithPlayerAccumulator.containsKey(player)) {
            this.entitiesCollidingWithPlayerAccumulator.put(player, new ArrayList());
        }
        this.entitiesCollidingWithPlayerAccumulator.get(player).add(entity);
    }

    public boolean isCollidingWithPlayer(LivingEntity player, Entity entity) {
        return this.entitiesCollidingWithPlayer.containsKey(player) && this.entitiesCollidingWithPlayer.get(player).contains(entity);
    }

    public boolean isCollidingWithPlayer(Entity entity) {
        return this.isCollidingWithPlayer(this.mod.getPlayer(), entity);
    }

    public Optional<ItemEntity> getClosestItemDrop(Item ... items) {
        return this.getClosestItemDrop(this.mod.getPlayer().m_20182_(), items);
    }

    public Optional<ItemEntity> getClosestItemDrop(Vec3 position, Item ... items) {
        return this.getClosestItemDrop(position, (ItemEntity entity) -> true, items);
    }

    public Optional<ItemEntity> getClosestItemDrop(Vec3 position, ItemTarget ... items) {
        return this.getClosestItemDrop(position, (ItemEntity entity) -> true, items);
    }

    public Optional<ItemEntity> getClosestItemDrop(Predicate<ItemEntity> acceptPredicate, Item ... items) {
        return this.getClosestItemDrop(this.mod.getPlayer().m_20182_(), acceptPredicate, items);
    }

    public Optional<ItemEntity> getClosestItemDrop(Vec3 position, Predicate<ItemEntity> acceptPredicate, Item ... items) {
        this.ensureUpdated();
        ItemTarget[] tempTargetList = new ItemTarget[items.length];
        for (int i = 0; i < items.length; ++i) {
            tempTargetList[i] = new ItemTarget(items[i], 9999999);
        }
        return this.getClosestItemDrop(position, acceptPredicate, tempTargetList);
    }

    public Optional<ItemEntity> getClosestItemDrop(Vec3 position, Predicate<ItemEntity> acceptPredicate, ItemTarget ... targets) {
        this.ensureUpdated();
        if (targets.length == 0) {
            Debug.logError("You asked for the drop position of zero items... Most likely a typo.");
            return Optional.empty();
        }
        if (!this.itemDropped(targets)) {
            return Optional.empty();
        }
        ItemEntity closestEntity = null;
        float minCost = Float.POSITIVE_INFINITY;
        for (ItemTarget target : targets) {
            for (Item item : target.getMatches()) {
                if (!this.itemDropped(item)) continue;
                for (ItemEntity entity : this.itemDropLocations.get(item)) {
                    float cost;
                    if (this.entityBlacklist.unreachable(entity) || !entity.m_32055_().m_41720_().equals(item) || !acceptPredicate.test(entity) || !((cost = (float)BaritoneHelper.calculateGenericHeuristic(position, entity.m_20182_())) < minCost)) continue;
                    minCost = cost;
                    closestEntity = entity;
                }
            }
        }
        return Optional.ofNullable(closestEntity);
    }

    private Class[] parsePossiblyNullEntityTypes(Class ... entityTypes) {
        return entityTypes == null ? (Class[])this.entityMap.keySet().toArray(Class[]::new) : entityTypes;
    }

    public Optional<Entity> getClosestEntity(Class ... entityTypes) {
        return this.getClosestEntity(this.mod.getPlayer().m_20182_(), entityTypes);
    }

    public Optional<Entity> getClosestEntity(Vec3 position, Class ... entityTypes) {
        return this.getClosestEntity(position, (Entity entity) -> true, entityTypes);
    }

    public Optional<Entity> getClosestEntity(Predicate<Entity> acceptPredicate, Class ... entityTypes) {
        return this.getClosestEntity(this.mod.getPlayer().m_20182_(), acceptPredicate, entityTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Entity> getClosestEntity(Vec3 position, Predicate<Entity> acceptPredicate, Class ... entityTypes) {
        entityTypes = this.parsePossiblyNullEntityTypes(entityTypes);
        Entity closestEntity = null;
        double minCost = Double.POSITIVE_INFINITY;
        for (Class toFind : entityTypes) {
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                if (this.entityMap.containsKey(toFind)) {
                    for (Entity entity : this.entityMap.get(toFind)) {
                        double cost;
                        if (this.entityBlacklist.unreachable(entity) || !entity.m_6084_() || !acceptPredicate.test(entity) || !((cost = entity.m_20238_(position)) < minCost)) continue;
                        minCost = cost;
                        closestEntity = entity;
                    }
                }
            }
        }
        return Optional.ofNullable(closestEntity);
    }

    public boolean itemDropped(Item ... items) {
        this.ensureUpdated();
        for (Item item : items) {
            if (!this.itemDropLocations.containsKey(item)) continue;
            for (ItemEntity entity : this.itemDropLocations.get(item)) {
                if (this.entityBlacklist.unreachable(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean itemDropped(ItemTarget ... targets) {
        this.ensureUpdated();
        for (ItemTarget target : targets) {
            if (!this.itemDropped(target.getMatches())) continue;
            return true;
        }
        return false;
    }

    public List<ItemEntity> getDroppedItems() {
        this.ensureUpdated();
        return this.itemDropLocations.values().stream().reduce(new ArrayList(), (result, drops) -> {
            result.addAll(drops);
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entityFound(Predicate<Entity> shouldAccept, Class ... types) {
        this.ensureUpdated();
        for (Class type : types = this.parsePossiblyNullEntityTypes(types)) {
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                for (Entity entity : this.entityMap.getOrDefault(type, Collections.emptyList())) {
                    if (!shouldAccept.test(entity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean entityFound(Class ... types) {
        return this.entityFound((Entity check) -> true, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> List<T> getTrackedEntities(Class<T> type) {
        this.ensureUpdated();
        if (!this.entityFound(type)) {
            return Collections.emptyList();
        }
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.entityMap.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> getCloseEntities() {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.closeEntities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CachedProjectile> getProjectiles() {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.projectiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LivingEntity> getHostiles() {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.hostiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlayerLoaded(String name) {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.playerMap.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllLoadedPlayerUsernames() {
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return new ArrayList<String>(this.playerMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Vec3> getPlayerMostRecentPosition(String name) {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return Optional.ofNullable(this.playerLastCoordinates.getOrDefault(name, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Player> getPlayerEntity(String name) {
        if (this.isPlayerLoaded(name)) {
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                return Optional.of(this.playerMap.get(name));
            }
        }
        return Optional.empty();
    }

    public void requestEntityUnreachable(Entity entity) {
        this.entityBlacklist.blackListItem(this.mod, entity, 3);
    }

    public boolean isEntityReachable(Entity entity) {
        return !this.entityBlacklist.unreachable(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void updateState() {
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            this.itemDropLocations.clear();
            this.entityMap.clear();
            this.closeEntities.clear();
            this.projectiles.clear();
            this.hostiles.clear();
            this.playerMap.clear();
            if (this.mod.getWorld() != null) {
                this.entitiesCollidingWithPlayer.clear();
                for (Map.Entry<LivingEntity, List<Entity>> collisions : this.entitiesCollidingWithPlayerAccumulator.entrySet()) {
                    this.entitiesCollidingWithPlayer.put(collisions.getKey(), new HashSet());
                    this.entitiesCollidingWithPlayer.get(collisions.getKey()).addAll((Collection<Entity>)collisions.getValue());
                }
                this.entitiesCollidingWithPlayerAccumulator.clear();
                for (Entity entity : this.mod.getWorld().m_8583_()) {
                    Class type = entity.getClass();
                    type = EntityTracker.squashType(type);
                    if (entity == null || !entity.m_6084_() || type == LivingEntity.class && entity.equals((Object)this.mod.getPlayer())) continue;
                    if (!this.entityMap.containsKey(type)) {
                        this.entityMap.put(type, new ArrayList());
                    }
                    this.entityMap.get(type).add(entity);
                    if (this.mod.getControllerExtras().inRange(entity)) {
                        this.closeEntities.add(entity);
                    }
                    if (entity instanceof ItemEntity) {
                        ItemEntity ientity = (ItemEntity)entity;
                        Item droppedItem = ientity.m_32055_().m_41720_();
                        if (ientity.m_20096_() || ientity.m_20069_() || WorldHelper.isSolidBlock(this.mod, ientity.m_20183_().m_6625_(2)) || WorldHelper.isSolidBlock(this.mod, ientity.m_20183_().m_6625_(3))) {
                            if (!this.itemDropLocations.containsKey(droppedItem)) {
                                this.itemDropLocations.put(droppedItem, new ArrayList());
                            }
                            this.itemDropLocations.get(droppedItem).add(ientity);
                        }
                    }
                    if (entity instanceof Mob) {
                        boolean closeEnough;
                        if (!EntityHelper.isAngryAtPlayer(this.mod, entity) || !(closeEnough = entity.m_19950_((Entity)this.mod.getPlayer(), 26.0))) continue;
                        this.hostiles.add((LivingEntity)entity);
                        continue;
                    }
                    if (entity instanceof Projectile) {
                        Projectile projEntity = (Projectile)entity;
                        if (this.mod.getBehaviour().shouldAvoidDodgingProjectile(entity)) continue;
                        CachedProjectile proj = new CachedProjectile();
                        boolean inGround = false;
                        if (entity instanceof AbstractArrow) {
                            inGround = ((PersistentProjectileEntityAccessor)entity).isInGround();
                        }
                        if (projEntity instanceof FishingHook || projEntity instanceof ThrownEnderpearl || projEntity instanceof ThrownExperienceBottle || inGround) continue;
                        proj.position = projEntity.m_20182_();
                        proj.velocity = projEntity.m_20184_();
                        proj.gravity = ProjectileHelper.hasGravity(projEntity) ? (double)0.05f : 0.0;
                        proj.projectileType = projEntity.getClass();
                        this.projectiles.add(proj);
                        continue;
                    }
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    String name = player.m_7755_().getString();
                    this.playerMap.put(name, player);
                    this.playerLastCoordinates.put(name, player.m_20182_());
                }
            }
        }
    }

    @Override
    protected void reset() {
        this.entityBlacklist.clear();
    }
}

