/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.google.common.collect.Streams;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class UserBlockRangeTracker
extends Tracker {
    final int AVOID_BREAKING_RANGE = 16;
    final Block[] USER_INDICATOR_BLOCKS = (Block[])Streams.concat((Stream[])new Stream[]{Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.BED))}).toArray(Block[]::new);
    final Block[] USER_BLOCKS_TO_AVOID_BREAKING = (Block[])Streams.concat((Stream[])new Stream[]{Arrays.asList(Blocks.f_50652_).stream(), Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.LOG))}).toArray(Block[]::new);
    private final Set<BlockPos> dontBreakBlocks = new HashSet<BlockPos>();

    public UserBlockRangeTracker(TrackerManager manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNearUserTrackedBlock(BlockPos pos) {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.dontBreakBlocks.contains(pos);
        }
    }

    @Override
    protected void updateState() {
        this.dontBreakBlocks.clear();
        List<BlockPos> userBlocks = this.mod.getBlockScanner().getKnownLocationsIncludeUnreachable(this.USER_INDICATOR_BLOCKS);
        HashSet<Block> userIndicatorBlocks = new HashSet<Block>(Arrays.asList(this.USER_INDICATOR_BLOCKS));
        HashSet<Block> userBlocksToAvoidMining = new HashSet<Block>(Arrays.asList(this.USER_BLOCKS_TO_AVOID_BREAKING));
        userBlocks.removeIf(bpos -> {
            Block bx = this.mod.getWorld().m_8055_(bpos).m_60734_();
            return !userIndicatorBlocks.contains(bx);
        });
        for (BlockPos userBlockPos : userBlocks) {
            BlockPos min = userBlockPos.m_7918_(-16, -16, -16);
            BlockPos max = userBlockPos.m_7918_(16, 16, 16);
            for (BlockPos possible : WorldHelper.scanRegion(min, max)) {
                Block b = this.mod.getWorld().m_8055_(possible).m_60734_();
                if (!userBlocksToAvoidMining.contains(b)) continue;
                this.dontBreakBlocks.add(possible);
            }
        }
    }

    @Override
    protected void reset() {
        this.dontBreakBlocks.clear();
    }
}

