/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util;

import com.player2.playerengine.player2api.Character;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Debug {
    private static final int DEBUG_LOG_LEVEL = 0;
    private static final int WARN_LOG_LEVEL = 1;
    private static final int ERROR_LOG_LEVEL = 2;
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");

    public static void logInternal(String message) {
        if (Debug.canLog(0)) {
            LOGGER.info("ALTO CLEF: {}", (Object)message);
        }
    }

    public static void logInternal(String format, Object ... args) {
        Debug.logInternal(String.format(format, args));
    }

    private static String getLogPrefix() {
        return "[Alto Clef] ";
    }

    public static void logMessage(String message, boolean prefix) {
        Debug.logInternal(message);
    }

    public static void logCharacterMessage(String message, Character character, boolean isPublic) {
        message = String.format("\u00a71\u00a7l\u00a7o<%s>\u00a7r %s", character.shortName(), message);
        Debug.logInternal(message);
    }

    public static void logUserMessage(String message) {
        Debug.logInternal(message);
    }

    public static void logMessage(String message) {
        Debug.logMessage(message, true);
    }

    public static void logMessage(String format, Object ... args) {
        Debug.logMessage(String.format(format, args));
    }

    public static void logWarning(String message) {
        if (Debug.canLog(1)) {
            System.out.println("ALTO CLEF: WARNING: " + message);
        }
    }

    public static void logWarning(String format, Object ... args) {
        Debug.logWarning(String.format(format, args));
    }

    public static void logError(String message) {
        String stacktrace = Debug.getStack(2);
        if (Debug.canLog(2)) {
            System.err.println(message);
            System.err.println("at:");
            System.err.println(stacktrace);
        }
    }

    public static void logError(String format, Object ... args) {
        Debug.logError(String.format(format, args));
    }

    public static void logStack() {
        Debug.logInternal("STACKTRACE: \n" + Debug.getStack(2));
    }

    private static String getStack(int toSkip) {
        StringBuilder stacktrace = new StringBuilder();
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (toSkip-- > 0) continue;
            stacktrace.append(ste.toString()).append("\n");
        }
        return stacktrace.toString();
    }

    private static boolean canLog(int level) {
        String enabledLogLevel;
        switch (enabledLogLevel = "ALL") {
            case "NONE": 
            case "ALL": {
                return true;
            }
            case "NORMAL": {
                return level == 1 || level == 2;
            }
            case "WARN": {
                return level == 1;
            }
            case "ERROR": {
                return level == 2;
            }
        }
        return level != 0;
    }
}

