/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.ItemTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CraftingHelper {
    public static boolean canCraftItemNow(PlayerEngineController mod, Item item) {
        ArrayList<ItemStack> inventoryItems = new ArrayList<ItemStack>();
        for (ItemStack stack : mod.getItemStorage().getItemStacksPlayerInventory(true)) {
            inventoryItems.add(new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_()));
        }
        for (CraftingRecipe recipe : mod.getCraftingRecipeTracker().getRecipeForItem(item)) {
            if (!CraftingHelper.canCraftItemNow(mod, new ArrayList<ItemStack>(inventoryItems), recipe, new HashSet<Item>())) continue;
            return true;
        }
        return false;
    }

    private static boolean canCraftItemNow(PlayerEngineController mod, List<ItemStack> inventoryStacks, CraftingRecipe recipe, HashSet<Item> alreadyChecked) {
        ItemTarget[] targets;
        Item recipeResult = mod.getCraftingRecipeTracker().getRecipeResult(recipe).m_41720_();
        if (alreadyChecked.contains(recipeResult)) {
            return false;
        }
        alreadyChecked.add(recipeResult);
        ItemTarget[] arrayOfItemTarget1 = targets = recipe.getSlots();
        int i = targets.length;
        int b = 0;
        block0: while (b < i) {
            ItemTarget itemTarget = arrayOfItemTarget1[b];
            if (itemTarget == ItemTarget.EMPTY) {
                b = (byte)(b + 1);
                continue;
            }
            for (Item item : itemTarget.getMatches()) {
                for (ItemStack inventoryStack : inventoryStacks) {
                    if (inventoryStack.m_41720_() != item || inventoryStack.m_41613_() < itemTarget.getTargetCount()) continue;
                    inventoryStack.m_41764_(inventoryStack.m_41613_() - itemTarget.getTargetCount());
                    continue block0;
                }
            }
            for (Item item : itemTarget.getMatches()) {
                if (!mod.getCraftingRecipeTracker().hasRecipeForItem(item)) continue;
                Iterator<Object> iterator = mod.getCraftingRecipeTracker().getRecipeForItem(item).iterator();
                while (iterator.hasNext()) {
                    ArrayList<ItemStack> inventoryStacksCopy = new ArrayList<ItemStack>(inventoryStacks);
                    CraftingRecipe newRecipe = (CraftingRecipe)iterator.next();
                    if (!CraftingHelper.canCraftItemNow(mod, inventoryStacksCopy, newRecipe, new HashSet<Item>(alreadyChecked))) continue;
                    inventoryStacks = inventoryStacksCopy;
                    ItemStack result = mod.getCraftingRecipeTracker().getRecipeResult(newRecipe);
                    result.m_41764_(result.m_41613_() - 1);
                    inventoryStacksCopy.add(result);
                    continue block0;
                }
            }
            return false;
        }
        return true;
    }
}

