/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.CachedProjectile;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class ProjectileHelper {
    public static final double ARROW_GRAVITY_ACCEL = (double)0.05f;
    public static final double THROWN_ENTITY_GRAVITY_ACCEL = 0.03;

    public static boolean hasGravity(Projectile entity) {
        return entity instanceof AbstractHurtingProjectile ? false : !entity.m_20068_();
    }

    private static Vec3 getClosestPointOnFlatLine(double shootX, double shootZ, double velX, double velZ, double playerX, double playerZ) {
        double deltaX = playerX - shootX;
        double deltaZ = playerZ - shootZ;
        double t = (velX * deltaX + velZ * deltaZ) / (velX * velX + velZ * velZ);
        double hitX = shootX + velX * t;
        double hitZ = shootZ + velZ * t;
        return new Vec3(hitX, 0.0, hitZ);
    }

    public static double getFlatDistanceSqr(double shootX, double shootZ, double velX, double velZ, double playerX, double playerZ) {
        return ProjectileHelper.getClosestPointOnFlatLine(shootX, shootZ, velX, velZ, playerX, playerZ).m_82531_(playerX, 0.0, playerZ);
    }

    private static double getArrowHitHeight(double gravity, double horizontalVel, double verticalVel, double initialHeight, double distanceTraveled) {
        double time = distanceTraveled / horizontalVel;
        return initialHeight - verticalVel * time - 0.5 * gravity * time * time;
    }

    public static Vec3 calculateArrowClosestApproach(Vec3 shootOrigin, Vec3 shootVelocity, double yGravity, Vec3 playerOrigin) {
        Vec3 flatEncounter = ProjectileHelper.getClosestPointOnFlatLine(shootOrigin.f_82479_, shootOrigin.f_82481_, shootVelocity.f_82479_, shootVelocity.f_82481_, playerOrigin.f_82479_, playerOrigin.f_82481_);
        double encounterDistanceTraveled = flatEncounter.m_82492_(shootOrigin.f_82479_, flatEncounter.f_82480_, shootOrigin.f_82481_).m_82553_();
        double horizontalVel = Math.sqrt(shootVelocity.f_82479_ * shootVelocity.f_82479_ + shootVelocity.f_82481_ * shootVelocity.f_82481_);
        double verticalVel = shootVelocity.f_82480_;
        double initialHeight = shootOrigin.f_82480_;
        double hitHeight = ProjectileHelper.getArrowHitHeight(yGravity, horizontalVel, verticalVel, initialHeight, encounterDistanceTraveled);
        return new Vec3(flatEncounter.f_82479_, hitHeight, flatEncounter.f_82481_);
    }

    public static Vec3 calculateArrowClosestApproach(CachedProjectile projectile, Vec3 pos) {
        return ProjectileHelper.calculateArrowClosestApproach(projectile.position, projectile.velocity, projectile.gravity, pos);
    }

    public static double[] calculateAnglesForSimpleProjectileMotion(double launchHeight, double launchTargetDistance, double launchVelocity, double gravity) {
        double y = -1.0 * launchHeight;
        double root = launchVelocity * launchVelocity * launchVelocity * launchVelocity - gravity * (gravity * launchTargetDistance * launchTargetDistance + 2.0 * y * launchVelocity * launchVelocity);
        if (root < 0.0) {
            Debug.logMessage("Not enough velocity, returning 45 degrees.");
            return new double[]{45.0, 45.0};
        }
        double tanTheta0 = (launchVelocity * launchVelocity + Math.sqrt(root)) / gravity * launchTargetDistance;
        double tanTheta1 = (launchVelocity * launchVelocity - Math.sqrt(root)) / gravity * launchTargetDistance;
        double[] angles = new double[]{Math.toDegrees(Math.atan(tanTheta0)), Math.toDegrees(Math.atan(tanTheta1))};
        return new double[]{Math.min(angles[0], angles[1]), Math.max(angles[0], angles[1])};
    }

    public static Vec3 getThrowOrigin(Entity entity) {
        return entity.m_20182_().m_82492_(0.0, 0.1, 0.0);
    }

    @Deprecated
    private static double getNearestTimeOfShotProjectile(Vec3 shootOrigin, Vec3 shootVelocity, double yGravity, Vec3 playerOrigin) {
        double r;
        double d;
        Vec3 D = playerOrigin.m_82546_(shootOrigin);
        double b = -(3.0 * yGravity * shootVelocity.f_82480_) / 2.0;
        double a = yGravity * yGravity / 2.0;
        double p = -b / 3.0 * a;
        double c = shootVelocity.m_82556_() + yGravity * shootVelocity.f_82480_;
        double q = p * p * p + (b * c - 3.0 * a * (d = -1.0 * shootVelocity.m_82526_(D))) / 6.0 * a * a;
        double rootInner = q * q + Math.pow((r = c / 3.0 * a) - p * p, 3.0);
        if (rootInner < 0.0) {
            return -1.0;
        }
        rootInner = Math.sqrt(rootInner);
        double outerPreCubeLeft = q + rootInner;
        double outerPreCubeRight = q - rootInner;
        return Math.pow(outerPreCubeLeft, 0.3333333333333333) + Math.pow(outerPreCubeRight, 0.3333333333333333) + p;
    }
}

