/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.serialization.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemListTypeAdapter
extends TypeAdapter<List<Item>> {
    public void write(JsonWriter out, List<Item> items) throws IOException {
        if (items == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (Item item : items) {
            String key = ItemHelper.trimItemName(item.m_5524_());
            out.value(key);
        }
        out.endArray();
    }

    public List<Item> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<Item> result = new ArrayList<Item>();
        in.beginArray();
        while (in.hasNext()) {
            String itemKey = in.nextString();
            ResourceLocation identifier = new ResourceLocation(itemKey = ItemHelper.trimItemName(itemKey));
            if (BuiltInRegistries.f_257033_.m_7804_(identifier)) {
                result.add((Item)BuiltInRegistries.f_257033_.m_7745_(identifier));
                continue;
            }
            Debug.logWarning("Invalid item name: " + itemKey);
        }
        in.endArray();
        return result;
    }
}

