/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata;

import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.firedev.emfpinata.UpdateChecker;
import uk.firedev.emfpinata.command.MainCommand;
import uk.firedev.emfpinata.config.MessageConfig;
import uk.firedev.emfpinata.libs.bstats.bukkit.Metrics;
import uk.firedev.emfpinata.libs.commandapi.CommandAPI;
import uk.firedev.emfpinata.libs.commandapi.CommandAPIBukkitConfig;
import uk.firedev.emfpinata.pinata.PinataListener;
import uk.firedev.emfpinata.pinata.PinataManager;

public final class EMFPinata
extends JavaPlugin {
    private static EMFPinata instance;
    private Metrics metrics = null;

    public void onLoad() {
        CommandAPIBukkitConfig config = (CommandAPIBukkitConfig)new CommandAPIBukkitConfig(this).shouldHookPaperReload(true).missingExecutorImplementationMessage("You are not able to use this command!");
        CommandAPI.onLoad(config);
    }

    public void onEnable() {
        instance = this;
        CommandAPI.onEnable();
        MessageConfig.getInstance().reload();
        PinataManager.getInstance().load();
        this.getServer().getPluginManager().registerEvents((Listener)new PinataListener(), (Plugin)this);
        this.registerCommands();
        this.metrics = this.loadMetrics();
        new UpdateChecker(this).checkUpdate().thenAccept(success -> {
            if (success.booleanValue()) {
                this.getLogger().info("A new update is available! Download it from https://modrinth.com/plugin/emfpinata");
            }
        });
    }

    public void onDisable() {
        PinataManager.getInstance().unload();
        CommandAPI.onDisable();
    }

    public static EMFPinata getInstance() {
        return instance;
    }

    public void reload() {
        MessageConfig.getInstance().reload();
        PinataManager.getInstance().reload();
    }

    private void registerCommands() {
        MainCommand.getCommand().register(this);
    }

    private Metrics loadMetrics() {
        return new Metrics((Plugin)this, 22866);
    }
}

