/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.command;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.firedev.emfpinata.libs.commandapi.SuggestionInfo;
import uk.firedev.emfpinata.libs.commandapi.arguments.Argument;
import uk.firedev.emfpinata.libs.commandapi.arguments.ArgumentSuggestions;
import uk.firedev.emfpinata.libs.commandapi.arguments.StringArgument;

public class ArgumentBuilder {
    public static Argument<String> getAsyncStringsArgument(@NotNull String name, @NotNull Function<SuggestionInfo<CommandSender>, String[]> function) {
        return (Argument)new StringArgument(name).includeSuggestions(ArgumentBuilder.getAsyncSuggestions(function));
    }

    public static ArgumentSuggestions<CommandSender> getAsyncSuggestions(@NotNull Function<SuggestionInfo<CommandSender>, String[]> function) {
        return ArgumentSuggestions.stringsAsync(info -> CompletableFuture.supplyAsync(() -> (String[])function.apply((SuggestionInfo<CommandSender>)info)));
    }

    @Nullable
    public static <T> T resolveArgument(@Nullable Object object, @NotNull Class<T> clazz) {
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        return null;
    }

    @NotNull
    public static <T> T resolveArgumentOrThrow(@Nullable Object object, @NotNull Class<T> clazz) {
        T resolved = ArgumentBuilder.resolveArgument(object, clazz);
        if (resolved == null) {
            throw new IllegalArgumentException("Argument is invalid or null.");
        }
        return resolved;
    }
}

