/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.config;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ConfigBase {
    private final boolean preventIO;
    private final String fileName;
    private final String resourceName;
    private final Plugin plugin;
    private final boolean configUpdater;
    private YamlDocument config = null;
    private File file = null;

    public ConfigBase(@NotNull File file, @NotNull Plugin plugin, boolean configUpdater) {
        this.preventIO = false;
        this.fileName = file.getName();
        this.resourceName = null;
        this.plugin = plugin;
        this.configUpdater = configUpdater;
        this.reload(file);
        this.update();
    }

    public ConfigBase(@NotNull String fileName, @NotNull String resourceName, @NotNull Plugin plugin, boolean configUpdater) {
        this.preventIO = false;
        this.fileName = fileName;
        this.resourceName = resourceName;
        this.plugin = plugin;
        this.configUpdater = configUpdater;
        this.reload(new File(this.getPlugin().getDataFolder(), this.getFileName()));
        this.update();
    }

    public ConfigBase() {
        this.preventIO = true;
        this.fileName = null;
        this.resourceName = null;
        this.plugin = null;
        this.configUpdater = false;
        try {
            this.config = YamlDocument.create((InputStream)InputStream.nullInputStream(), (Settings[])this.getSettings());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void reload(@NotNull File configFile) {
        if (this.preventIO) {
            return;
        }
        Settings[] settings = this.getSettings();
        try {
            InputStream resource = this.getResourceName() == null ? null : this.getPlugin().getResource(this.getResourceName());
            this.config = resource == null ? YamlDocument.create((File)configFile, (Settings[])settings) : YamlDocument.create((File)configFile, (InputStream)resource, (Settings[])settings);
            this.file = configFile;
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void reload() {
        if (this.preventIO || this.file == null) {
            return;
        }
        this.reload(this.file);
    }

    public final YamlDocument getConfig() {
        if (this.config == null) {
            throw new IllegalStateException("Config " + this.getFileName() + " is not loaded. Please check for startup errors.");
        }
        return this.config;
    }

    public final File getFile() {
        return this.file;
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public Settings[] getSettings() {
        ArrayList<Settings> settingsList = new ArrayList<Settings>(Arrays.asList(this.getGeneralSettings(), this.getDumperSettings(), this.getLoaderSettings()));
        if (this.configUpdater) {
            settingsList.add((Settings)this.getUpdaterSettings());
        }
        return (Settings[])settingsList.toArray(Settings[]::new);
    }

    public GeneralSettings getGeneralSettings() {
        return GeneralSettings.builder().setUseDefaults(false).build();
    }

    public DumperSettings getDumperSettings() {
        return DumperSettings.DEFAULT;
    }

    public LoaderSettings getLoaderSettings() {
        return LoaderSettings.DEFAULT;
    }

    public UpdaterSettings getUpdaterSettings() {
        return UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("version")).setKeepAll(true).setEnableDowngrading(false).build();
    }

    public void save() {
        if (this.preventIO) {
            return;
        }
        try {
            this.getConfig().save();
        }
        catch (IOException exception) {
            this.plugin.getLogger().warning("Failed to save " + this.getFileName());
        }
    }

    public void update() {
        if (this.preventIO || !this.configUpdater) {
            return;
        }
        try {
            this.getConfig().update();
        }
        catch (IOException exception) {
            this.plugin.getLogger().warning("Failed to update " + this.getFileName());
        }
    }
}

