/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.commandapi;

import org.bukkit.plugin.Plugin;
import uk.firedev.emfpinata.libs.commandapi.PaperImplementations;

public class Schedulers {
    private final PaperImplementations paperImplementations;

    public Schedulers(PaperImplementations paperImplementations) {
        this.paperImplementations = paperImplementations;
    }

    public int scheduleSyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        if (this.paperImplementations.isFoliaPresent()) {
            plugin.getServer().getGlobalRegionScheduler().runAtFixedRate(plugin, task -> runnable.run(), delay <= 0L ? 1L : delay, period);
            return 1;
        }
        return plugin.getServer().getScheduler().runTaskTimer(plugin, runnable, delay, period).getTaskId();
    }

    public void cancelTask(Plugin plugin, int id) {
        if (this.paperImplementations.isFoliaPresent()) {
            plugin.getServer().getGlobalRegionScheduler().cancelTasks(plugin);
        } else {
            plugin.getServer().getScheduler().cancelTask(id);
        }
    }

    public void scheduleSync(Plugin plugin, Runnable runnable) {
        if (this.paperImplementations.isFoliaPresent()) {
            plugin.getServer().getGlobalRegionScheduler().execute(plugin, runnable);
        } else {
            plugin.getServer().getScheduler().runTask(plugin, runnable);
        }
    }

    public void scheduleSyncDelayed(Plugin plugin, Runnable runnable, long delay) {
        if (this.paperImplementations.isFoliaPresent()) {
            plugin.getServer().getGlobalRegionScheduler().runDelayed(plugin, task -> runnable.run(), delay <= 0L ? 1L : delay);
        } else {
            plugin.getServer().getScheduler().runTaskLater(plugin, runnable, delay);
        }
    }

    public void scheduleAsync(Plugin plugin, Runnable runnable) {
        if (this.paperImplementations.isFoliaPresent()) {
            plugin.getServer().getAsyncScheduler().runNow(plugin, task -> runnable.run());
        } else {
            plugin.getServer().getScheduler().runTaskAsynchronously(plugin, runnable);
        }
    }
}

