/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import uk.firedev.emfpinata.libs.commandapi.CommandAPIBukkit;
import uk.firedev.emfpinata.libs.commandapi.arguments.CommandAPIArgumentType;
import uk.firedev.emfpinata.libs.commandapi.arguments.SafeOverrideableArgument;
import uk.firedev.emfpinata.libs.commandapi.executors.CommandArguments;

public class AsyncOfflinePlayerArgument
extends SafeOverrideableArgument<CompletableFuture<OfflinePlayer>, OfflinePlayer> {
    public AsyncOfflinePlayerArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentProfile(), OfflinePlayer::getName);
    }

    @Override
    public Class<CompletableFuture<OfflinePlayer>> getPrimitiveType() {
        return CompletableFuture.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ASYNC_OFFLINE_PLAYER;
    }

    @Override
    public <CommandSourceStack> CompletableFuture<OfflinePlayer> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CommandAPIBukkit.get().getOfflinePlayer(cmdCtx, key);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

