/*
 * Decompiled with CFR 0.152.
 */
package uk.firedev.emfpinata.libs.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import uk.firedev.emfpinata.libs.commandapi.CommandAPIBukkit;
import uk.firedev.emfpinata.libs.commandapi.IStringTooltip;
import uk.firedev.emfpinata.libs.commandapi.StringTooltip;
import uk.firedev.emfpinata.libs.commandapi.SuggestionInfo;
import uk.firedev.emfpinata.libs.commandapi.arguments.Argument;
import uk.firedev.emfpinata.libs.commandapi.arguments.CommandAPIArgumentType;
import uk.firedev.emfpinata.libs.commandapi.executors.CommandArguments;

public class ListArgumentCommon<T>
extends Argument<List> {
    private final String delimiter;
    private final boolean allowDuplicates;
    private final Function<SuggestionInfo<CommandSender>, Collection<T>> supplier;
    private final Function<T, IStringTooltip> mapper;
    private final boolean text;

    ListArgumentCommon(String nodeName, String delimiter, boolean allowDuplicates, Function<SuggestionInfo<CommandSender>, Collection<T>> supplier, Function<T, IStringTooltip> suggestionsMapper, boolean text) {
        super(nodeName, (ArgumentType<?>)(text ? StringArgumentType.string() : StringArgumentType.greedyString()));
        this.delimiter = delimiter;
        this.allowDuplicates = allowDuplicates;
        this.supplier = supplier;
        this.mapper = suggestionsMapper;
        this.text = text;
        this.applySuggestions();
    }

    private void applySuggestions() {
        this.replaceSuggestions((info, builder) -> {
            String currentArg = info.currentArg();
            if (this.text && currentArg.startsWith("\"")) {
                currentArg = currentArg.substring(1);
                builder = builder.createOffset(builder.getStart() + 1);
            }
            HashSet<IStringTooltip> values = new HashSet<IStringTooltip>();
            for (T object : this.supplier.apply(info)) {
                values.add(this.mapper.apply(object));
            }
            String[] splitArguments = currentArg.split(Pattern.quote(this.delimiter));
            String lastArgument = splitArguments[splitArguments.length - 1];
            if (!currentArg.endsWith(this.delimiter)) {
                if (values.stream().map(IStringTooltip::getSuggestion).anyMatch(lastArgument::equals)) {
                    values.add(StringTooltip.none(lastArgument + this.delimiter));
                }
            }
            if (!this.allowDuplicates) {
                for (String str : splitArguments) {
                    IStringTooltip valueToRemove = null;
                    for (IStringTooltip value : values) {
                        if (!value.getSuggestion().equals(str)) continue;
                        valueToRemove = value;
                        break;
                    }
                    if (valueToRemove == null) continue;
                    values.remove(valueToRemove);
                }
            }
            if (currentArg.contains(this.delimiter)) {
                builder = builder.createOffset(builder.getStart() + currentArg.lastIndexOf(this.delimiter) + this.delimiter.length());
            }
            for (IStringTooltip str : values) {
                if (!str.getSuggestion().startsWith(builder.getRemaining())) continue;
                if (str.getTooltip() == null) {
                    builder.suggest(str.getSuggestion());
                    continue;
                }
                builder.suggest(str.getSuggestion(), str.getTooltip());
            }
            return builder.buildFuture();
        });
    }

    @Override
    public Class<List> getPrimitiveType() {
        return List.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LIST;
    }

    @Override
    public <CommandSourceStack> List<T> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        SuggestionInfo<CommandSender> currentInfo = new SuggestionInfo<CommandSender>(sender, previousArgs, cmdCtx.getInput(), (String)cmdCtx.getArgument(key, String.class));
        HashMap<String, T> values = new HashMap<String, T>();
        for (T object : this.supplier.apply(currentInfo)) {
            values.put(this.mapper.apply(object).getSuggestion(), object);
        }
        ArrayList list = new ArrayList();
        HashSet<String> listKeys = new HashSet<String>();
        String argument = (String)cmdCtx.getArgument(key, String.class);
        String[] strArr = argument.split(Pattern.quote(this.delimiter));
        StringReader context = new StringReader(argument);
        for (String str : strArr) {
            if (!values.containsKey(str)) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage("Item is not allowed in list")).createWithContext((ImmutableStringReader)context);
            }
            if (!this.allowDuplicates && listKeys.contains(str)) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage("Duplicate arguments are not allowed")).createWithContext((ImmutableStringReader)context);
            }
            list.add(values.get(str));
            listKeys.add(str);
            context.setCursor(context.getCursor() + str.length() + this.delimiter.length());
        }
        return list;
    }
}

